/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.bridge;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.openide.src.Element;
import org.openide.src.Identifier;

/**
 * Support for multivalued properties holding identifier arrays and advanced change
 * detection and property firing. The support is implemented as a flyweight, so it does
 * not contain any state-specific fields, but is bound to a property and bean class.
 * Concrete subclass will add methods for accessing state of the bean.
 *
 * @author  sdedic
 * @version 
 */
abstract class IdentifierArrayProperty extends FlyweightIndexedProperty {
    /** Tag value (and performance enhancement) for properties with no identifiers
     * in them.
     */
    static final Identifier[] EMPTY = new Identifier[0];

    /** Constructs the flyweight and binds it to a property name.
     */
    public IdentifierArrayProperty(String propName) {
        super(propName);
    }

    /** Returns the tag value for an empty array of identifiers.
     */
    protected final Object[] createValue(int size) {
        return size == 0 ? EMPTY : new Identifier[size];
    }
    
    protected final Object[] createEmpty() {
        return EMPTY;
    }

    protected boolean compareValues(Object one, Object two) {
        // assume both are identifiers.
        Identifier id1 = (Identifier)one;
        Identifier id2 = (Identifier)two;

        return MemberElementImpl.compareSourceIdentifiers(id1, id2);
    }
    
    protected boolean compareValuesForRemove(Object one, Object two) {
        Identifier id1 = (Identifier)one;
        Identifier id2 = (Identifier)two;
        return id1.compareTo(id2, false);
    }
}

