/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.java.bridge;

import java.util.*;
import java.lang.ref.*;

import org.openide.src.Identifier;

/**
 *
 * @author  sdedic
 * @version 
 */
class IdentContextSupport extends Object {
    Map     identifierSet;
    
    public IdentContextSupport(int capacity) {
        identifierSet = new HashMap(capacity * 4 / 3);
    }
    
    public Identifier create(Identifier id, int status) {
        Reference refV = (Reference)identifierSet.get(id.getSourceName());
        if (refV != null) {
            Identifier oldID = (Identifier)refV.get();
            if (oldID != null) {
                if (oldID.getResolutionStatus() == status && 
                    oldID.getFullName() == id.getFullName())
                    // exactly the same identifier with a matching status.
                    return oldID;
            }
        }
        if (id.getResolutionStatus() != status) {
            id = Identifier.create(id.getFullName(), id.getSourceName(), status);
        }
        identifierSet.put(id.getSourceName(), new WeakReference(id));
        return id;
    }
    
    public boolean checkContext(Identifier id) {
        Reference refV = (Reference)identifierSet.get(id);
        if (refV == null)
            return false;
        Identifier x = (Identifier)refV.get();
        return x == id;
    }
}
