/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.bridge;

import java.beans.PropertyChangeEvent;
import java.util.*;

/**
 * PENDING: Remove FlyweightIndexedProperty class entirely, move createXXX events
 * to the IndexedPropertyBase and have the subclasses implement getSource() method.
 *
 */
public abstract class FlyweightIndexedProperty extends IndexedPropertyBase {
    public FlyweightIndexedProperty(String propertyName) {
        super(propertyName);
    }

    protected abstract Object[] getValue(ElementImpl beanImpl);
    
    protected abstract Object[] createValue(int size);

    /** Creates a PropertyChangeEvent that informs about insertion of some items at
     * the end of the value array. The event does not contain indices for the insertion.
     */
    public PropertyChangeEvent add(ElementImpl beanImpl, Object[] adding) {
        Object[] oldVal = getValue(beanImpl);
        Object[] newVal = createValue(oldVal.length + adding.length);
        System.arraycopy(oldVal, 0, newVal, 0, oldVal.length);
        System.arraycopy(adding, 0, newVal, oldVal.length, adding.length);
        return createInsertionEvent(beanImpl.getElement(), oldVal, newVal.clone(), Arrays.asList(adding), 
            null);
    }

    /** Creates a PropertyChangeEvent that informs about removal of some items.
     */
    public PropertyChangeEvent remove(ElementImpl beanImpl, Object[] toRemove) {
        Object[] oldVal = getValue(beanImpl);
        Object[] newVal = applyRemove(oldVal, toRemove);
        return createRemovalEvent(beanImpl.getElement(), oldVal, newVal.clone(), Arrays.asList(toRemove), null);
    }
    
    protected boolean compareValuesForRemove(Object old, Object removed) {
        return compareValues(old, removed);
    }
    
    /** Filters out the items that should be removed and creates a list of new ones. Uses
     * a dumb algorithm O(n^2) for searching for objects to be removed and uses
     */
    private Object[] applyRemove(Object[] oldVals, Object[] remove) {
        List result = new ArrayList(oldVals.length - remove.length);
        for (int i = 0; i < oldVals.length; i++) {
            boolean shouldRemove = false;
            for (int j = 0; !shouldRemove && j < remove.length; j++) {
                if (oldVals[i] == remove[j] || compareValuesForRemove(oldVals[i], remove[j])) {
                    shouldRemove = true;
                }
            }
            if (!shouldRemove) 
                result.add(oldVals[i]);
        }
        return result.toArray(createValue(0));
    }
    
    /** Creates a generic PropertyChangeEvent.
     */
    public PropertyChangeEvent set(ElementImpl beanImpl, Object[] newVal) {
        Object[] oldVal = getValue(beanImpl);
        return createChangeEvent(beanImpl.getElement(), oldVal, (Object[])newVal.clone());
    }
}
