/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.bridge;

import java.util.*;
import java.lang.reflect.Modifier;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaClassClass;
import org.netbeans.jmi.javamodel.FieldClass;
import org.netbeans.jmi.javamodel.MethodClass;
import org.netbeans.jmi.javamodel.ConstructorClass;
import org.netbeans.jmi.javamodel.InitializerClass;
import org.netbeans.jmi.javamodel.ParameterClass;
import org.netbeans.jmi.javamodel.ImportClass;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Initializer;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Resource;

import org.openide.src.*;

public class FeaturesCollection {
    private static final Element[] NO_ELEMENTS = new Element[0];
    static final Type[] NO_TYPES = new Type[0];
    
    ElementImpl parentImpl;
    ClassElement parentClass;
    
    MDRepository repository;
    JavaClass javaClass;
    Resource resource;
    DefaultLangModel model;

    JavaClassClass classProxy;
    FieldClass fieldProxy;
    MethodClass methodProxy;
    ConstructorClass constructorProxy;
    InitializerClass initializerProxy;
    ParameterClass parameterProxy;
    ImportClass importProxy;
    
    // variables corresponding to an element marked to be current
    
    private Feature currentElement = null;
    private boolean insertBefore;
    
    // initialization ...........................................................
        
    public FeaturesCollection(ElementImpl parentImpl) {
        this.parentImpl = parentImpl;
                
        repository = parentImpl.repository;
        if (parentImpl instanceof ClassElementImpl) {
            javaClass = (JavaClass) parentImpl.getJavaElement ();
            resource = javaClass.getResource();
        }
        model = parentImpl.getModelImpl ();
        
        if (parentImpl.javaModelPackage != null) {
            try {
                classProxy = parentImpl.javaModelPackage.getJavaClass ();
                fieldProxy = parentImpl.javaModelPackage.getField ();
                methodProxy = parentImpl.javaModelPackage.getMethod ();
                constructorProxy = parentImpl.javaModelPackage.getConstructor ();
                initializerProxy = parentImpl.javaModelPackage.getInitializer ();
                parameterProxy = parentImpl.javaModelPackage.getParameter ();
                importProxy = parentImpl.javaModelPackage.getImport ();
            } catch (javax.jmi.reflect.InvalidObjectException e) {
            }
        }
    }
    
    // ..........................................................................                                    

    public ClassElement getParentClass () {
        if (parentClass == null)
            parentClass = (ClassElement) parentImpl.getElement ();
        return parentClass;
    }
        
    // helper methods ...........................................................
    
    public List typesToDescriptors (Type[] types) {
        List result = new LinkedList ();
        for (int x = 0; x < types.length; x++) {
            result.add (parentImpl.typeToDescr (types [x]));
        }
        return result;
    }
    
    public List convertParameters (MethodParameter[] params) {
        List result = new LinkedList ();
        for (int x = 0; x < params.length; x++) {
            Parameter par = parameterProxy.createParameter (
                params [x].getName (),
                null,
                params [x].isFinal (),
                null,
                0,
                false
            );
            Type type = params[x].getType();
            Type t = type;
            while (t.isArray()) {
                t = t.getElementType();
            }                            
            if (t.isPrimitive()) {
                par.setType(parentImpl.typeToDescr(type));
            } else {
                par.setTypeName(parentImpl.typeToTypeReference(type));
            }
            result.add (par);
        }
        return result;
    }
    
    public List convertIdentifiers (Identifier [] ids) {
        List result = new LinkedList ();
        for (int x = 0; x < ids.length; x++) {
            result.add (parentImpl.typeToDescr (Type.createClass (ids[x])));
        }
        return result;
    }
        
    // ..........................................................................
    
    public JavaClass createClass (ClassElement cls) {        
        int x;
        List features = new ArrayList();
        
        FieldElement [] fields = cls.getFields ();
        for (x = 0; x < fields.length; x++) {
            features.add(createField (fields [x]));
        }
        InitializerElement [] initializers = cls.getInitializers ();
        for (x = 0; x < initializers.length; x++) {
            features.add(createInitializer (initializers [x]));
        }
        ConstructorElement [] constrs = cls.getConstructors ();
        for (x = 0; x < constrs.length; x++) {
            features.add(createConstructor (constrs [x]));
        }
        MethodElement [] methods = cls.getMethods ();
        for (x = 0; x < methods.length; x++) {
            features.add(createMethod (methods [x]));
        }
        ClassElement [] classes = cls.getClasses ();
        for (x = 0; x < classes.length; x++) {
            features.add(createClass (classes [x]));
        }

        String simpleName = cls.getName().getName();
        Identifier parentName = null;
        if (parentImpl instanceof ClassElementImpl) {
            parentName = ((ClassElementImpl) parentImpl).getName();
        }
        else {
            SourceElementImpl sei = (SourceElementImpl) parentImpl;
            parentName = sei.getPackage();
        }
        String fullName = simpleName;
        if (parentName !=null) {
            String parentFqn=parentName.getFullName();
            
            if (parentFqn.length()>0)
                fullName=parentName+"."+simpleName; // NOI18N
        }
        Identifier className = Identifier.create(fullName, simpleName);
        Identifier superclass = cls.getSuperclass ();
        int modifier = cls.getModifiers();
        
        if (!cls.isClassOrInterface())
            modifier |= Modifier.INTERFACE;
        JavaClass res = classProxy.createJavaClass (
            className.getFullName (),
            null, // annotations
            modifier,
            cls.getJavaDoc().getRawText (),
            null, // JavaDoc
            features,
            null,
            null,
            null // typeArguments
        );
        
        if (superclass != null) {
            res.setSuperClass ((JavaClass) parentImpl.javaModelPackage.getType().resolve(superclass.getFullName()));            
        }
        
        Identifier [] interfaces = cls.getInterfaces ();
        List inters = new ArrayList(interfaces.length);
        for (int i = 0; i < interfaces.length; i++) {            
            inters.add(parentImpl.javaModelPackage.getMultipartId().createMultipartId(interfaces[i].getFullName(), null, null));
        }                
        res.getInterfaceNames().addAll(inters);
        return res;
    }
    
    public Method createMethod (MethodElement method) {
        Method res = methodProxy.createMethod (
            method.getName ().getName (),
            null, // annotations
            method.getModifiers (),
            method.getJavaDoc().getRawText (),
            null, // JavaDoc
            null, // StatementBlock
            method.getBody (),
            null, // typeArguments
            convertParameters (method.getParameters ()),
            null,
            null,
            0
        );
        Type retType = method.getReturn();
        Type t = retType;
        while (t.isArray()) {
            t = t.getElementType();
        }                            
        if (t.isPrimitive()) {
            res.setType(parentImpl.typeToDescr(retType));
        } else {
            res.setTypeName(parentImpl.typeToTypeReference(retType));
        }
        Identifier [] exs = method.getExceptions ();
        List list = new ArrayList (exs.length);
        for (int x = 0; x < exs.length; x++) {
            String excName = exs[x].getSourceName();
            if (excName == null)
                excName = exs[x].getFullName();
            list.add (parentImpl.javaModelPackage.getMultipartId().createMultipartId(excName, null, null));
        }
        res.getExceptionNames().addAll(list);
        return res;
    }

    public Constructor createConstructor (ConstructorElement constr) {
        Constructor res = constructorProxy.createConstructor(
            null,
            null, // annotations
            constr.getModifiers (),
            constr.getJavaDoc ().getRawText (),
            null, // JavaDoc
            null, // StatementBlock
            constr.getBody (), // body text
            null, // typeArguments
            convertParameters (constr.getParameters ()),
            null // thrown exceptions
        );
        Identifier [] exs = constr.getExceptions ();
        List list = new ArrayList (exs.length);
        for (int x = 0; x < exs.length; x++) {            
            list.add (parentImpl.javaModelPackage.getMultipartId().createMultipartId(exs[x].getFullName(), null, null));
        }
        res.getExceptionNames().addAll(list);
        return res;
    }
    
    public Field createField (FieldElement field) {                
        String initValue = field.getInitValue();
        if ((initValue != null) && (initValue.length() == 0))
            initValue = null;
        Field res = fieldProxy.createField (
            field.getName ().getName (),
            null, // annotations
            field.getModifiers (),
            field.getJavaDoc().getRawText (),
            null, // JavaDoc
            (field.getModifiers () & Modifier.FINAL) > 0, // isFinal
            null, // typeName
            0, // dimCount
            null, // InitialValue
            initValue // initial value text
        );
        res.setType(parentImpl.typeToDescr(field.getType ()));
        return res;
    }

    public Initializer createInitializer (InitializerElement initializer) {
        JavaDoc javaDoc = initializer.getJavaDoc ();        
        Initializer res = initializerProxy.createInitializer (
            "<clinit>", // name // NOI18N
            null, // annotations
            initializer.isStatic () ? Modifier.STATIC : 0, // modifiers
            javaDoc != null ? javaDoc.getRawText() : null, // javadocText
            null, // JavaDoc
            null, // StatementBlock
            initializer.getBody () // bodyText
        );
        return res;
    }
    
    public org.netbeans.jmi.javamodel.Import createImport (ImportElement elem) {
        Import imp = elem.getImport ();
        String name = imp.getIdentifier ().getFullName ();
        org.netbeans.jmi.javamodel.Import res = importProxy.createImport (
            name,
            null,
            false,
            imp.isPackage()
        );
        return res;
    }
    
}
