/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.bridge;

import org.openide.src.*;

import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Initializer;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.Import;

/**
 *
 * @author  svata
 * @version 
 */
public interface ElementCreator {
    public ClassElementImpl         createTopClass(SourceElement parent, JavaClass javaClass);
    public ClassElementImpl         createInnerClass(ClassElement parent, JavaClass javaClass);
    public FieldElementImpl         createField(ClassElement parent, Field field);
    public MethodElementImpl        createMethod(ClassElement parent, Method method);
    public ConstructorElementImpl   createConstructor(ClassElement parent, Constructor constructor);
    public InitializerElementImpl   createInitializer(ClassElement parent, Initializer initializer);    
    public ImportImpl               createImport(SourceElement parent, Import imp);
    
    public ClassElementImpl         createTopClass(SourceElement parent);
    public ClassElementImpl         createInnerClass(ClassElement parent);
    public FieldElementImpl         createField(ClassElement parent);
    public MethodElementImpl        createMethod(ClassElement parent);
    public ConstructorElementImpl   createConstructor(ClassElement parent);
    public InitializerElementImpl   createInitializer(ClassElement parent);
    public ImportImpl               createImport(SourceElement parent);
    
    public SourceElementImpl        createSource();
    public WrapperFactory           getWrapper();

    // Identifier management
    public Identifier createLocalIdentifier(Element context,
        String full, String src, int status);
    public Identifier createLocalIdentifier(Element context,
        Identifier original, int status);
    public boolean isSameContext(Element context, Identifier id);
}
