/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.bridge;

import org.openide.src.*;

/**
 *
 * @author  sdedic
 * @version 
 */
class EditingRunnable implements ExceptionRunnable {
    public static final int OP_MODIFIERS = 0;
    public static final int OP_NAME = 1;
    public static final int OP_SUPERCLASS = 2;
    public static final int OP_SUPERINTERFACES = 3;
    public static final int OP_EXCEPTIONS = 4;
    public static final int OP_PARAMETERS = 5;
    public static final int OP_RETURNTYPE = 6;
    public static final int OP_CHANGE_FIELDS = 7;
    public static final int OP_CHANGE_METHODS = 8;
    public static final int OP_CHANGE_CONSTRUCTORS = 9;
    public static final int OP_CHANGE_INITIALIZERS = 10;
    public static final int OP_CHANGE_CLASSES = 11;
    public static final int OP_BODY = 12;
    public static final int OP_CLASSFLAG = 13;
    public static final int OP_PACKAGE = 14;
    public static final int OP_IMPORT = 15;
    
    ElementImpl impl;
    int op;
    int mods;
    Identifier name;
    Element[] elems;
    Identifier[] ids;
    MethodParameter[] params;
    Type rettype;
    String str;
    boolean flag;
    Import imp;
    
    public EditingRunnable(ElementImpl impl, boolean flag) {
        this.impl = impl;
        this.flag = flag;
        this.op = OP_CLASSFLAG;
    }
    
    public EditingRunnable(ElementImpl impl, Import i) {
        this.impl = impl;
        this.imp = i;
        this.op = OP_IMPORT;
    }
    
    public EditingRunnable(ElementImpl impl, int mods) {
        this.impl = impl;
        this.mods = mods;
        this.op = OP_MODIFIERS;
    }
    
    public EditingRunnable(ElementImpl impl, int opcode, Element[] elems, int changeCode) {
        this.impl = impl;
        this.op = opcode;
        this.elems = elems;
        this.mods = changeCode;
    }
    
    public EditingRunnable(ElementImpl impl, MethodParameter[] params) {
        this.impl = impl;
        this.params = params;
        this.op = OP_PARAMETERS;
    }
    
    public EditingRunnable(ElementImpl impl, Identifier[] ids, int operation) {
        this.impl = impl;
        this.op = OP_SUPERINTERFACES;
        this.ids = ids;
        this.mods = operation;
    }
    
    public EditingRunnable(ElementImpl impl, Identifier[] ids) {
        this.impl = impl;
        this.ids = ids;
        this.op = OP_EXCEPTIONS;
    }
    
    public EditingRunnable(ElementImpl impl, int opcode, Identifier name) {
        this.impl = impl;
        this.name = name;
        this.op = opcode;
    }
        
    public EditingRunnable(ElementImpl impl, Type rettype) {
        this.impl = impl;
        this.rettype = rettype;
        this.op = OP_RETURNTYPE;
    }
    
    public EditingRunnable(ElementImpl impl, String str) {
        this.impl = impl;
        this.op = OP_BODY;
        this.str = str;
    }
    
    public void run() throws SourceException {
        switch (op) {
            /*
            case OP_MODIFIERS:
                ((MemberElementImpl)impl).doSetModifiers(mods);
                break;
            case OP_NAME:
                ((MemberElementImpl)impl).doSetName(name);
                break;
            case OP_SUPERCLASS:
                ((ClassElementImpl)impl).doSetSuperclass(name);
                break;
            case OP_SUPERINTERFACES:
                ((ClassElementImpl)impl).doChangeInterfaces(ids, mods);
                break;
            case OP_EXCEPTIONS:
                ((CallableImpl)impl).doSetExceptions(ids);
                break;
            case OP_PARAMETERS:
                ((CallableImpl)impl).doSetParameters(params);
                break;
            case OP_RETURNTYPE:
                ((MethodElementImpl)impl).doSetReturn(rettype);
                break;
            case OP_CHANGE_FIELDS:
                ((ClassElementImpl)impl).doChangeFields(elems, mods);
                break;
            case OP_CHANGE_METHODS:
                ((ClassElementImpl)impl).doChangeMethods(elems, mods);
                break;
            case OP_CHANGE_CONSTRUCTORS:
                ((ClassElementImpl)impl).doChangeConstructors(elems, mods);
                break;
            case OP_CHANGE_INITIALIZERS:
                ((ClassElementImpl)impl).doChangeInitializers(elems, mods);
                break;
            case OP_CHANGE_CLASSES:
                ((ClassElementImpl)impl).doChangeClasses(elems, mods);
                break;
            case OP_BODY:
                ((CallableImpl)impl).doSetBody(str);
                break;
            case OP_CLASSFLAG:
                ((ClassElementImpl)impl).doSetClassOrInterface(flag);
                break;
            case OP_IMPORT:
                ((ImportImpl)impl).doSetImport(imp);
                break;
            default:
                throw new InternalError("Unsupported edit operation"); // NOI18N
             */
        }
    }
}
