/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.bridge;

import org.openide.src.*;

public class DefaultWrapper implements WrapperFactory {
    private static WrapperFactory instance;
    
    public synchronized static WrapperFactory getInstance() {
        if (instance != null)
            return instance;
        return instance = new DefaultWrapper();
    }

    /* ----------------- wrapper factory methods --------------------- */
    public FieldElement wrapField(FieldElement.Impl theImpl, Element parent) {
        return new FieldElement(theImpl, (ClassElement)parent);
    }
    
    public ClassElement wrapClass(ClassElement.Impl theImpl, Element parent) {
        if (parent instanceof SourceElement) {
            return new ClassElement(theImpl, (SourceElement)parent);
        } else {
            return new ClassElement(theImpl, (ClassElement)parent);
        }
    }
    
    public MethodElement wrapMethod(MethodElement.Impl theImpl, Element parent) {
        return new MethodElement(theImpl, (ClassElement)parent);
    }
    
    public ConstructorElement wrapConstructor(ConstructorElement.Impl theImpl, Element parent) {
        return new ConstructorElement(theImpl, (ClassElement)parent);
    }
    
    public InitializerElement wrapInitializer(InitializerElement.Impl theImpl, Element parent) {
        return new InitializerElement(theImpl, (ClassElement)parent);
    }
    
    public ImportElement wrapImport(ImportElement.Impl theImpl, Element parent) {
        return new ImportElement(theImpl, (SourceElement)parent);
    }
}
