/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.bridge;

// import java.beans.PropertyChangeEvent;
import java.util.*;
import java.util.Iterator;

import org.openide.src.*;

import javax.jmi.reflect.RefObject;

import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaClassImpl;

class ClassesCollection extends ObjectsCollection {

    static final ClassElement[] EMPTY = new ClassElement[0];
    
    public ClassesCollection(FeaturesCollection members) {
        super (members);
    }

    public RefObject createFeature(RefObject parent, Element elem) {
        return members.createClass ((ClassElement) elem);
    }
    
    public Element [] getEmptyArray () {
        return EMPTY;
    }
    
    public String getPropertyName () {
        return ElementProperties.PROP_CLASSES;
    }
    
    public boolean isOfType (RefObject feature) {
        return feature instanceof JavaClass;
    }
    
    public Element createElement (RefObject innerClass) {
        return (ClassElement) members.model.createInnerClass (members.getParentClass (), (JavaClass)innerClass).getElement ();
    }
 
    public ClassElement getClass(Identifier name) {
        members.repository.beginTrans(false);
        try {
            if (isValid()) {
                String simpleName = name.getName();
                JavaClass innerClass = members.javaClass.getInnerClass(simpleName, false);            
                if (innerClass == null)
                    return null;
                String fqn = name.getFullName ();
                if (!fqn.equals (name.getName ()) && !fqn.equals (innerClass.getName ()))
                    return null;
                return (ClassElement) cachedElement (innerClass);
            } else {
                return null;
            }
        } finally {
            members.repository.endTrans();
        }
    }
    
    public ClassElement[] getClasses () {
        return (ClassElement[]) getElements ();
    }
    
    public boolean matches (Element elem, RefObject f) {
        JavaClass javaClass = (JavaClass) f;
        ClassElement classElem = (ClassElement) elem;
        String simpleName = javaClass.getSimpleName();
        return classElem.getName ().getName ().equals (simpleName);
    }
    
    public int getPositionalValue () {
        return ObjectsCollection.POS_VAL_CLASS;
    }
}
