/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java;

import java.io.IOException;

import org.openide.filesystems.FileObject;
import org.netbeans.modules.java.parser.ParseObjectRequest;

/** Simple interface to a parser engine
 *  The engine should process passed source file(s) and give out enough information
 *  to produce Java Hierarchy classes for the source. The engine should not only
 *  parse, but resolve identifiers as well; doing that, it is free to open other
 *  source files.
 * @author  sdedic
 * @version 
 */
public interface ParserEngine {
    /** Registers a new request with the parser engine.
        When a request is registered, it can be processed at any time. The engine
        can carry this task during processing of other requests.
     * @param r Request to be registered
     * @param fo FileObject that the request should be bound to. The request will
     * be processed if the parser/compiler touches `fo' during other processing.
    */
    public void register(ParseObjectRequest r, FileObject fo);

    /**
     * Unregisters a request filed for the given FileObject. 
     */
    public void unregister(FileObject fo);

    /** Determines if a parse request is already registered with the engine.
    */
    public boolean isRegistered(ParseObjectRequest r);

    /** Clears all requests in the parser engine.
    */
    public void unregisterAll();

    /** Process the request immediately. The method returns after the request is
        completed (either successfully or with some errors).
        If request was already completed, it is processed again yielding fresh
        results.
    */
    public void process(ParseObjectRequest r) throws IOException;
}
