/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * ParserAnnontation.java
 *
 * Created on March 27, 2002, 6:53 PM
 */

package org.netbeans.modules.java;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.jmi.javamodel.ErrorType;
import org.netbeans.jmi.javamodel.ErrorTypeEnum;
import org.openide.text.Line;
import org.openide.text.Annotatable;
import org.openide.text.Line.Set;

/**
 *
 * @author  th125165
 */
class ParserAnnotation extends LineSetAnnotation implements PropertyChangeListener {
    
    private final String error;
    private final int line,column;
    private int state;
    private final ErrorType severity;
    private Line docline;
    private ParserAnnotation chained;
    
    private static final int STATE_NEW=1;
    private static final int STATE_ATTACHED = 2;
    private static final int STATE_DETACHED = 3;
    
    /** Creates a new instance of ParserAnnontation */
    ParserAnnotation(int l, int c, ErrorType sev, String err) {
        line=l;
        column=c;
        error = err;
        state = STATE_NEW;
        severity = sev;
    }
    
    public String getAnnotationType() {
        if (ErrorTypeEnum.ERROR.equals(getSeverity())) {
            return "org-netbeans-modules-java-parser_annotation_err";  // NOI18N
        } else {
            return "org-netbeans-modules-java-parser_annotation_warn"; // NOI18N
        }
    }
    
    public String getShortDescription() {
        // Localize this with NbBundle:
        if (chained!=null)
            return error+"\n\n"+chained.getShortDescription(); // NOI18N
        return error;
    }
    
    int getLine() {
        return line;
    }
    
    int getColumn() {
        return column;
    }
    
    String getError() {
        return error;
    }
    
    ErrorType getSeverity() {
        return severity;
    }
    
    void chain(ParserAnnotation anno) {
        if (chained!=null)
            chained.chain(anno);
        else
            chained=anno;
    }
    
    private int getState() {
        return state;
    }
    
    protected void notifyAttached(final Annotatable toAnno) {
        super.notifyAttached(toAnno);
        docline.addPropertyChangeListener(this);
        state = STATE_ATTACHED;
    }
    
    protected void notifyDetached(Annotatable fromAnno) {
        super.notifyDetached(fromAnno);
        docline.removePropertyChangeListener(this);
        state=STATE_DETACHED;
    }
    
    public boolean equals(Object obj) {
        boolean eq=shallowEquals(obj);
        
        if (!eq)
            return false;
        if (chained!=null)
            return chained.equals(((ParserAnnotation)obj).chained);
        return true;
    }
           
    private boolean shallowEquals(Object obj) {
        if (obj instanceof ParserAnnotation) {
            ParserAnnotation ann=(ParserAnnotation)obj;
            
            if (this==obj)
                return true;
            if (line!=ann.getLine())
                return false;
            if (column!=ann.getColumn())
                return false;
            if (!error.equals(ann.getError()))
                return false;
            if (getState()==STATE_DETACHED || ann.getState()==STATE_DETACHED)
                return false;
            return true;
        }
        return false;
    }
    
    public void attachToLineSet(Set lines) {
        char string[];
        int start,end;
        Line.Part part;
        
        try {
            docline=lines.getCurrent(line-1);
        } catch (IndexOutOfBoundsException ex) {
            // the document has been changed and the line is deleted
            return;
        }
        String annTxt = docline.getText();
        if (annTxt == null) return; // document is already closed
        string = annTxt.toCharArray();
        start=0;
        end=string.length-1;
        while (start<=end && string[start]<=' ') {
            start++;
        }
        while (start<=end && string[end]<=' ') {
            end--;
        }
        if (start<=end)
            part=docline.createPart(start,end-start+1);
        else
            part=docline.createPart(0,string.length);
        attach(part);
    }
    
    public void propertyChange(PropertyChangeEvent ev) {
        String type = ev.getPropertyName();
        if (type == null || type == Annotatable.PROP_TEXT) {    // User edited the line, assume error should be cleared.
            detach();
        }
    }
}
