/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java;

import org.netbeans.modules.javacore.internalapi.GuardedResolver;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.text.PositionBounds;

/**
 *
 * @author Jan Becicka
 */
public final class DocumentGuardedResolver implements GuardedResolver {
    
    /** Creates a new instance of DocumentGuardedResolver */
    private DocumentGuardedResolver() {
    }
    
    private static DocumentGuardedResolver instance = null;
    
    public static synchronized DocumentGuardedResolver getDefault() {
        if (instance == null) {
            instance = new DocumentGuardedResolver();
        }
        return instance;
    }

    public final boolean isSectionGuarded(org.netbeans.jmi.javamodel.Resource resource, org.openide.text.PositionBounds bounds) {
        JavaEditor editor = (JavaEditor) JavaMetamodel.getManager().getDataObject(resource).getCookie(JavaEditor.class);
        PositionBounds begin = new PositionBounds(bounds.getBegin(), bounds.getBegin());
        PositionBounds end = new PositionBounds(bounds.getEnd(), bounds.getEnd());
        return !editor.testOverlap(begin) || !editor.testOverlap(end);
    }
}
