/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * TestDefaultLibraries.java
 * NetBeans JUnit based test
 *
 * Created on 06 September 2004, 15:37
 */

package projects;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;

import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

import junit.framework.*;
import org.netbeans.jellytools.JellyTestCase;
import org.netbeans.junit.*;

import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.project.libraries.Library;

/**
 * 
 */
public class TestLibraries extends JellyTestCase {
    
    public TestLibraries(java.lang.String testName) {
        super(testName);
    }
    
    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
    public static Test suite() {
        TestSuite suite = new NbTestSuite(TestLibraries.class);
        return suite;
    }
    
    // -------------------------------------------------------------------------
    
    public void testDefaultLibraries() {
        
        LibraryManager libMan = LibraryManager.getDefault();
        Library [] libs = libMan.getLibraries();
        
        for (int i = 0; i < libs.length; i++) {
                        
            File refFile = null;
            PrintStream ps = null;
            // names of files are based on library name
            String baseName = libs[i].getName();
            String refFileName = baseName + "_ref.txt";
            String goldenFileName = baseName + "_pass.txt";
            String diffFileName = baseName + "_diff.txt";
            
            // write library data to ref file
            try {
            	ps = new PrintStream(new java.io.FileOutputStream(new File(getWorkDir(), refFileName)));
            } catch (Exception exc) {
            	fail(exc.getMessage());
            }
            
            List listOfClasspaths = libs[i].getContent("classpath");
            dumpList("", listOfClasspaths, ps);
            List listOfJavadocs = libs[i].getContent("javadoc");
            dumpList("", listOfJavadocs, ps);
            List listOfSrcs = libs[i].getContent("src");
            dumpList("", listOfSrcs, ps);
            ps.close();
            
            try {
                compareReferenceFiles(refFileName, goldenFileName, diffFileName);
            } catch (Exception exc) {
		fail(exc.getMessage());
            }
            
        }
        
    }
    
    public void __testCreateLibrary() {
        
        // learn hostname
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        } catch (UnknownHostException uhe) {
            fail("Cannot get hostname: " + uhe.getMessage()); // NOI18N
        }
        hostName = hostName.replace('-', '_');
        
        // load platforms.properties file
        InputStream is = this.getClass().getResourceAsStream("libraries.properties");
        Properties props = new Properties();
        try {
            props.load(is);
        } catch (java.io.IOException ioe) {
            fail("Cannot load platforms properties: " + ioe.getMessage()); // NOI18N
        }
        
        String[] libCp = getTokensAsArray(props.getProperty(hostName + "library1_cp"));
        String[] libSrc = getTokensAsArray(props.getProperty(hostName + "library1_src"));
        String[] libJdoc = getTokensAsArray(props.getProperty(hostName + "library1_jdoc"));
        
        TestProjectUtils.addLibrary(props.getProperty(hostName + "library1_name"), 
            libCp, libSrc, libJdoc);
    }
    
    public void __testListDefaultLibraries() {
        listDefaultLibs("e:\\work\\libs\\");
    }
    
    // -------------------------------------------------------------------------
    
    /* This method is intended only for generation of golden files from Beta2 release build
     */
    private void listDefaultLibs(String folder) {
        
        PrintStream pw = null;
        LibraryManager libMan = LibraryManager.getDefault();
        Library [] libs = libMan.getLibraries();
        
        for (int i = 0; i < libs.length; i++) {
            try {
                pw = new PrintStream(new FileOutputStream(folder + libs[i].getName() + ".txt"));
            } catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
            }
            
            System.out.println("Display name: " + libs[i].getDisplayName());
            System.out.println("Name: " + libs[i].getName());
            List listOfClasspaths = libs[i].getContent("classpath");
            dumpList("Classpath: ", listOfClasspaths, System.out);
            dumpList("", listOfClasspaths, pw);
            List listOfJavadocs = libs[i].getContent("javadoc");
            dumpList("Javadoc: ", listOfJavadocs, System.out);
            dumpList("", listOfJavadocs, pw);
            List listOfSrcs = libs[i].getContent("src");
            dumpList("Sources: ", listOfSrcs, System.out);
            dumpList("", listOfSrcs, pw);            
            pw.close();
            
        }
        
    }
    
    private void dumpList(String prefix, List list, PrintStream ps) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            ps.println(prefix + iter.next());
        }
    }
    
    private String[] getTokensAsArray(String str) {
        StringTokenizer st = new StringTokenizer(str, ",");
        String[] array = new String[st.countTokens()];
        int index = 0;
        while (st.hasMoreTokens()) {
            array[index++] = st.nextToken().trim();
        }
        return array;
    }
    
}
