/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * TestCreateProject.java
 * NetBeans JUnit based test
 *
 * Created on July 1, 2004, 1:58 PM
 */

package projects;

import junit.framework.*;

import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.JellyTestCase;
import org.netbeans.jellytools.NbDialogOperator;
import org.netbeans.jellytools.NewProjectNameLocationStepOperator;
import org.netbeans.jellytools.NewProjectWizardOperator;
import org.netbeans.jellytools.ProjectsTabOperator;

import org.netbeans.jellytools.nodes.ProjectRootNode;

import org.netbeans.jemmy.operators.JCheckBoxOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;

import org.netbeans.junit.*;

/**
 *
 */
public class TestCreateProject extends JellyTestCase {
    
    String standardLabel = Bundle.getStringTrimmed("org.netbeans.modules.java.j2seproject.ui.wizards.Bundle",
            "Templates/Project/Standard");
    String applicationLabel = Bundle.getStringTrimmed("org.netbeans.modules.java.j2seproject.ui.wizards.Bundle",
            "Templates/Project/Standard/emptyJ2SE.xml");
    String libraryLabel = Bundle.getStringTrimmed("org.netbeans.modules.java.j2seproject.ui.wizards.Bundle",
            "Templates/Project/Standard/emptyJ2SElibrary.xml");
    String existingLabel = Bundle.getStringTrimmed("org.netbeans.modules.java.j2seproject.ui.wizards.Bundle",
            "Templates/Project/Standard/existingJ2SE.xml");
    String scanningLabel = Bundle.getStringTrimmed("org.netbeans.modules.javacore.Bundle",
            "TXT_ApplyingPathsTitle");
    
    public TestCreateProject(java.lang.String testName) {
        super(testName);
    }
    
    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
    public static Test suite() {
        TestSuite suite = new NbTestSuite(TestCreateProject.class);
        return suite;
    }
 
    public void setUp() {
        System.out.println("########  " + getName() + "  #######"); // NOI18N
    }
    
    // -------------------------------------------------------------------------
    
    /**
     *  Test of creating default project (Set as Main Project, Main Class)
     */
    public void testCreateProject_1() throws Exception {
        
        String projName = "TestApp_1"; // NOI18N
        String pkg = "org.netbeans"; // NOI18N
        String mainClass = "MyMain" + projName; // NOI18N
        
        createJavaApplication(projName, getWorkDir().getAbsolutePath(), true, pkg + "." + mainClass);
        NbDialogOperator scanningDialogOper = new NbDialogOperator(scanningLabel);
        scanningDialogOper.getTimeouts().setTimeout("ComponentOperator.WaitStateTimeout", 180000);
        scanningDialogOper.waitClosed();
        
        new ProjectsTabOperator().getProjectRootNode(projName);
        
        // Verify that correct project has been created
        TestProjectUtils.verifyProjectExists(projName);
        
        // Main class created and opened in editor
        TestProjectUtils.verifyMainClassInEditor(mainClass + ".java");
        
        // Verify that created project can be built and run
        TestProjectUtils.verifyProjectBuilds(projName);
        
    }
    
    /**
     *  Test of creating project (Set as Main Project, no Main Class)
     */
    public void testCreateProject_2() throws Exception {
        
        String projName = "TestApp_2"; // NOI18N
        
        createJavaApplication(projName, getWorkDir().getAbsolutePath(), true, null);
        NbDialogOperator scanningDialogOper = new NbDialogOperator(scanningLabel);
        scanningDialogOper.getTimeouts().setTimeout("ComponentOperator.WaitStateTimeout", 180000);
        scanningDialogOper.waitClosed();
        
        new ProjectsTabOperator().getProjectRootNode(projName);
        
        // Verify that correct project has been created
        TestProjectUtils.verifyProjectExists(projName);
        
        // Verify that created project can be built
        TestProjectUtils.verifyProjectBuilds(projName);
    }
    
    /**
     *  Test of creating project (Not set as Main Project, Main Class)
     */
    public void testCreateProject_3() throws Exception {
        
        String projName = "TestApp_3"; // NOI18N
        String pkg = "org.netbeans"; // NOI18N
        String mainClass = "MyMain" + projName; // NOI18N
        
        createJavaApplication(projName, getWorkDir().getAbsolutePath(), false, pkg + "." + mainClass);
        NbDialogOperator scanningDialogOper = new NbDialogOperator(scanningLabel);
        scanningDialogOper.getTimeouts().setTimeout("ComponentOperator.WaitStateTimeout", 180000);
        scanningDialogOper.waitClosed();
        
        new ProjectsTabOperator().getProjectRootNode(projName);
        
        // Verify that correct project has been created
        TestProjectUtils.verifyProjectExists(projName);
        
        // Main class created and opened in editor
        TestProjectUtils.verifyMainClassInEditor(mainClass + ".java");
        
        // Verify that created project can be built and run
        TestProjectUtils.verifyProjectBuilds(projName);
        
    }
    
    /**
     *  Test of creating project (Not set as Main Project, no Main Class)
     */
    public void testCreateProject_4() throws Exception {
        
        String projName = "TestApp_4"; // NOI18N
        
        createJavaApplication(projName, getWorkDir().getAbsolutePath(), false, null);
        NbDialogOperator scanningDialogOper = new NbDialogOperator(scanningLabel);
        scanningDialogOper.getTimeouts().setTimeout("ComponentOperator.WaitStateTimeout", 180000);
        scanningDialogOper.waitClosed();
        
        new ProjectsTabOperator().getProjectRootNode(projName);
        
        // Verify that correct project has been created
        TestProjectUtils.verifyProjectExists(projName);
        
        // Verify that created project can be built
        TestProjectUtils.verifyProjectBuilds(projName);
        
    }
    
    /**
     *  Test of creating default project - Class Library
     */
    public void testCreateProject_5() throws Exception {
        
        String projName = "TestLib_1"; // NOI18N
        
        createJavaLibrary(projName, getWorkDir().getAbsolutePath());
        NbDialogOperator scanningDialogOper = new NbDialogOperator(scanningLabel);
        scanningDialogOper.getTimeouts().setTimeout("ComponentOperator.WaitStateTimeout", 180000);
        scanningDialogOper.waitClosed();
        
        new ProjectsTabOperator().getProjectRootNode(projName);
        
        // Verify that correct project has been created
        TestProjectUtils.verifyProjectExists(projName);
        
        // Verify that created project can be built
        TestProjectUtils.verifyProjectBuilds(projName);
        
    }
    
    /**
     * Test of creating project from existing sources
     */
    public void testCreateProject_6() throws Exception {
        
        String projName = "ExSources_1"; // NOI18N
        
        createJavaApplicationWithExistingSources(projName, getWorkDir().getAbsolutePath(), 
            getDataDir() + java.io.File.separator + "srcroot1", null, true);
        
        NbDialogOperator scanningDialogOper = new NbDialogOperator(scanningLabel);
        scanningDialogOper.getTimeouts().setTimeout("ComponentOperator.WaitStateTimeout", 180000);
        scanningDialogOper.waitClosed();
        
        ProjectRootNode prn = new ProjectsTabOperator().getProjectRootNode(projName);
        prn.expand();
        
        // Verify that correct project has been created
        TestProjectUtils.verifyProjectExists(projName);
        
        // Verify that created project can be built
        TestProjectUtils.verifyProjectBuilds(projName);
        
    }
    
    // -------------------------------------------------------------------------
      
    /** 
     * Creates New Java Application Project
     * @param projName Name of the project
     * @param projLocation Project folder location
     * @param mainProj Set project as main
     * @param mainClass if null then no main class created, 
     *   if "" then default main class, otherwise given String represents main class incl. package
     */
    private void createJavaApplication(String projName, String projLocation, boolean mainProj, String mainClass) {
        
        // select the right template
        NewProjectWizardOperator npwo = NewProjectWizardOperator.invoke();
        npwo.selectCategory(standardLabel);
        npwo.selectProject(applicationLabel);
        npwo.next();
        
        // project name
        NewProjectNameLocationStepOperator npnlso = new NewProjectNameLocationStepOperator();
        npnlso.txtProjectName().clearText();
        npnlso.txtProjectName().setText(projName);
        
        // project location
        npnlso.txtProjectLocation().clearText();
        npnlso.txtProjectLocation().setText(projLocation);
        
        // set project as main
        JCheckBoxOperator mainProjOper = npnlso.cbSetAsMainProject();
        if (!mainProj && mainProjOper.isSelected()) {
            mainProjOper.doClick();
        }
        
        // set project main class
        //JCheckBoxOperator mainClassOper = npnlso.cbCreateMainClass(); // - FIX NEEDED!
        JCheckBoxOperator mainClassOper = new JCheckBoxOperator(npnlso, 1);
        JTextFieldOperator mainClassFieldOper = new JTextFieldOperator(npnlso, 3);
        if (mainClass == null) {
            if (mainClassOper.isSelected()) {
                mainClassOper.doClick();
            }
        } else {
            if (!mainClassOper.isSelected()) {
                mainClassOper.doClick();
            }
            if (!mainClass.equals("")) {
                mainClassFieldOper.clearText();
                mainClassFieldOper.typeText(mainClass);
            }
        }
        npnlso.finish();
        
    }
    
    /** 
     * Creates New Java Class Library Project
     * @param projName Name of the project
     * @param projLocation Project folder location
     */
    private void createJavaLibrary(String projName, String projLocation) {
        
        // select the right template
        NewProjectWizardOperator npwo = NewProjectWizardOperator.invoke();
        npwo.selectCategory(standardLabel);
        npwo.selectProject(libraryLabel);
        npwo.next();
        
        // project name
        NewProjectNameLocationStepOperator npnlso = new NewProjectNameLocationStepOperator();
        npnlso.txtProjectName().clearText();
        npnlso.txtProjectName().setText(projName);
        
        // project location
        npnlso.txtProjectLocation().clearText();
        npnlso.txtProjectLocation().setText(projLocation);
        
        npnlso.finish();
        
    }
    
    /**
     * Creates Java Application from existing sources
     * @param projName Name of the project
     * @param projLocation Project folder location
     * @param srcPkgFolder Location of source folder
     * @param testPkgFolder Location of test folder
     * @param mainProj Set Project as main
     */
    private void createJavaApplicationWithExistingSources(String projName, String projLocation, 
            String srcPkgFolder, String testPkgFolder, boolean mainProj) {
        
        // select the right template
        NewProjectWizardOperator npwo = NewProjectWizardOperator.invoke();
        npwo.selectCategory(standardLabel);
        npwo.selectProject(existingLabel);
        npwo.next();
        
        // project name
        NewProjectNameLocationStepOperator npnlso = new NewProjectNameLocationStepOperator();
        npnlso.txtProjectName().setText(projName);
        
        fail("THIS TEST SHOULD BE UPDATED.");
        /*
        
        // project folder
        npnlso.txtProjectFolder().setText(projLocation);
        
        // source packages folder
        // should be checked for null
        npnlso.txtSourcePackagesFolder().setText(srcPkgFolder);
        
        // set project as main
        JCheckBoxOperator mainProjOper = npnlso.cbSetAsMainProject();
        if (!mainProj && mainProjOper.isSelected()) {
            mainProjOper.doClick();
        }
        
        // test packages folder
        if (testPkgFolder != null || !"".equals(testPkgFolder)) {
            npnlso.txtTestPackagesFolder().setText(testPkgFolder);
        }
        
        npnlso.finish();
        */
    }
        
}
