
%{
/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/* byaccJ options:
 * -Jpackage=org.netbeans.lib.java.parser -Jimplements=ASTreeTypes,JParser -Jsemantic=ASTClass -d 
*/
    import java.io.*;
%}


/* keywords */
%token ABSTRACT,ASSERT,BOOLEAN,BREAK,BYTE,CASE,CATCH,CHAR,CLASS,CONST,CONTINUE
%token DEFAULT,DO,DOUBLE,ELSE,ENUM,EXTENDS,FINAL,FINALLY,FLOAT,FOR,GOTO,IF
%token IMPLEMENTS,IMPORT,INSTANCEOF,INT,INTERFACE,LONG,NATIVE,NEW,PACKAGE
%token PRIVATE,PROTECTED,PUBLIC,RETURN,SHORT,STATIC,STRICTFP,SUPER,SWITCH
%token SYNCHRONIZED,THIS,THROW,THROWS,TRANSIENT,TRY,VOID,VOLATILE,WHILE

/* separators */
%token L_PAR,R_PAR,L_CURLY,R_CURLY,L_BRACKET,R_BRACKET,SEMICOLON,COMMA,DOT
%token MONKEYS_AT,ELLIPSIS

/* operators */
%token ASSIGN,GT,LT,NOT,COMP,QUESTION,COLON,EQ,LTE,GTE,NEQ,BOOL_AND,BOOL_OR
%token INCREMENT,DECREMENT,PLUS,MINUS,MULTI,DIV,AND,OR,XOR,MOD,L_SHIFT
%token R_SHIFT,UR_SHIFT,PLUS_ASSIGN,MINUS_ASSIGN,MULTI_ASSIGN,DIV_ASSIGN
%token AND_ASSIGN,OR_ASSIGN,XOR_ASSIGN,MOD_ASSIGN,L_SHIFT_ASSIGN,R_SHIFT_ASSIGN
%token UR_SHIFT_ASSIGN

/* literals */
%token BOOL_LIT,INT_LIT,FLOAT_LIT,CHAR_LIT,STRING_LIT,NULL_LIT

/* identifier */
%token IDENTIFIER

/* padding tokens */
%token COMMENT,EOL_COMMENT,DOC_COMMENT,WHITESPACE,EOL

/* end of file */
%token EOF

/* error */
%token ERROR

%start compilation_unit

%%
/* 4.1 */
type: primitive_type 
    | reference_type 
    ;

/* 4.2 */
primitive_type: numeric_type { $$=new ASTreeNode(astContext,PRIMITIVE_TYPE,$1); }
    | BOOLEAN { $$=new ASTreeNode(astContext,PRIMITIVE_TYPE,$1); }
    | VOID /* only for methods */ { $$=new ASTreeNode(astContext,PRIMITIVE_TYPE,$1); }
    ;

numeric_type: integer_type
    | floating_point_type
    ;

integer_type: BYTE
    | SHORT
    | INT
    | LONG
    | CHAR
    ;

floating_point_type: FLOAT
    | DOUBLE
    ;

/* 4.3 */
reference_type: multi_part_id 
    | multi_part_id dims { $$ = new ASTreeNode(astContext,REFERENCE_TYPE,$1,$2); }
    | primitive_type dims { $$ = new ASTreeNode(astContext,REFERENCE_TYPE,$1,$2); }
    ;


/* 7.3 */
compilation_unit: package_declaration import_declarations type_declarations { $$ = new ASTreeNode(astContext,COMPILATION_UNIT,new ASTree[]{$1,$2,$3});  /* System.out.println($$); */ }
    ;

import_declarations: /* empty */ { $$ = null; }
    | import_declarations import_declaration { if ($1==null) $$=new ASTreeNode(astContext,IMPORT_DECLARATIONS,$2); else $$=$1.addSubTree($2); } 
    ;

type_declarations: /* empty */ { $$ = null; }
    | type_declarations type_declaration { if ($1==null) $$=new ASTreeNode(astContext,TYPE_DECLARATIONS,$2); else $$=$1.addSubTree($2); }
    ;

/* 7.4.1 */
package_declaration: /* empty */ { $$ = null; }
	| PACKAGE multi_part_id SEMICOLON { $$ = new ASTreeNode(astContext,PACKAGE_DECLARATION,$1,$3,$2); }
    ;

/* 7.5 */
import_declaration: single_type_import_declaration 
    | type_import_on_demand_declaration
    ;

/* 7.5.1 */
single_type_import_declaration: IMPORT static_opt multi_part_id SEMICOLON { $$ = new ASTreeNode(astContext,SINGLE_TYPE_IMPORT,$1,$4,new ASTree[]{$2,$3}); }
    ;

/* 7.5.2 */
type_import_on_demand_declaration: IMPORT static_opt multi_part_id DOT MULTI SEMICOLON { $$ = new ASTreeNode(astContext,TYPE_IMPORT_ON_DEMAND,$1,$6,new ASTree[]{$2,$3}); }
    ;

static_opt: /* empty */ { $$=null; }
    | STATIC
    ;

/* 7.6 */
type_declaration : class_declaration
    | interface_declaration
    | SEMICOLON
    ;

/* 8.1 */ 
class_declaration: modifiers CLASS IDENTIFIER super interfaces class_body { $$ = new ASTreeNode(astContext,CLASS_DECLARATION,$1,$6,new ASTree[]{$1,$3,null,$4,$5,$6}); /* System.out.println("Class:"+((Token)$3).getValue()); */ }
    | CLASS IDENTIFIER super interfaces class_body { $$ = new ASTreeNode(astContext,CLASS_DECLARATION,$1,$5,new ASTree[]{null,$2,null,$3,$4,$5}); /* System.out.println("Class:"+((Token)$2).getValue()); */ }
    ;

/* 8.1.1 */
/* removed 
    class_modifiers: *//* empty */
/*    | class_modifiers class_modifier
    ;

class_modifier: PUBLIC
    | PROTECTED
    | PRIVATE
    | ABSTRACT
    | STATIC
    | FINAL
    | STRICTFP
    ;
*/

/* 8.1.3 */
super : /* empty */ { $$=null; }
    | EXTENDS multi_part_id { $$=new ASTreeNode(astContext,SUPER_,$1,$2,$2); }
    ;

/* 8.1.4 */
interfaces: /* empty */ { $$=null; }
    | IMPLEMENTS id_type_list { $$ = $2.setFirstToken($1); }
    ;

id_type_list: multi_part_id { $$ = new ASTreeNode(astContext,TYPE_LIST,$1,$1,$1); }
    | id_type_list COMMA multi_part_id { $$=$1.addSubTree($3); }
    ;

/* 8.1.5 */
class_body: L_CURLY class_body_declarations R_CURLY { if ($2!=null) $$=$2.setFirstAndLastToken($1,$3);
                                                      else $$=new ASTreeNode(astContext,CLASS_BODY_DECLARATIONS,$1,$3,new ASTree[0]); }
    ;

class_body_declarations: /* empty */ {$$=null; }
    | class_body_declarations class_body_declaration { if ($1==null) $$=new ASTreeNode(astContext,CLASS_BODY_DECLARATIONS,$2); else $$=$1.addSubTree($2); }
    ;

class_body_declaration: class_member_declaration 
    | instance_initializer 
    | static_initializer
    | constructor_declaration
    ;

class_member_declaration: field_declaration
    | method_declaration
    | class_declaration
    | interface_declaration
    | SEMICOLON
    ;

/* 8.3 */
field_declaration: modifiers type variable_declarators SEMICOLON { $$ = new ASTreeNode(astContext,FIELD_DECLARATION,$1,$4,new ASTree[]{$1,$2,$3}); }
    | type variable_declarators SEMICOLON { $$ = new ASTreeNode(astContext,FIELD_DECLARATION,$1,$3,new ASTree[]{null,$1,$2}); }
    ;

variable_declarators: variable_declarator 
    | variable_declarators COMMA variable_declarator { if ($1.getType()!=VARIABLE_DECLARATORS) $$=new ASTreeNode(astContext,VARIABLE_DECLARATORS,$1,$3);
                                                       else $$=$1.addSubTree($3); }
    ;

variable_declarator: variable_declarator_id variable_initializer_opt { $$=$1.addSubTree($2); }
    ;

variable_declarator_id: IDENTIFIER { $$=new ASTreeNode(astContext,VARIABLE_DECLARATOR,$1,$1,new ASTree[]{$1,null}); }
    | IDENTIFIER dims { $$=new ASTreeNode(astContext,VARIABLE_DECLARATOR,$1,$2,new ASTree[]{$1,$2}); }
    ;

variable_initializer_opt: /* empty */ { $$=null; }
    | ASSIGN variable_initializer { $$=$2; }
    ;

variable_initializer: expression
    | array_initializer
    ;

/* 8.3.1 */
/* removed 
field_modifiers:
    | field_modifiers field_modifier
    ;

field_modifier: PUBLIC
    | PROTECTED
    | PRIVATE
    | STATIC
    | FINAL 
    | TRANSIENT
    | VOLATILE
    ;
*/

/* 8.4 */
method_declaration: method_header method_body { $$=$1.addSubTree($2); }
    ;

method_header: modifiers type method_declarator throws { $$=new ASTreeNode(astContext,METHOD_DECLARATION,new ASTree[]{$1,null,$2,$3,$4}); }
    | type method_declarator throws { $$=new ASTreeNode(astContext,METHOD_DECLARATION,new ASTree[]{null,null,$1,$2,$3}); }
    ;

/*
result_type: type
    | VOID
    ;
*/

method_declarator: modern_method_declarator { $$=$1.addSubTree(null); }
    | modern_method_declarator dims { $$=$1.addSubTree($2); }
    ;

modern_method_declarator: IDENTIFIER L_PAR formal_parameter_list_opt R_PAR { $$=new ASTreeNode(astContext,METHOD_DECLARATOR,$1,$4,new ASTree[]{$1,$3}); }
    ;


/* 8.4.1 */
formal_parameter_list_opt : /* empty */ { $$=null; }
    | formal_parameter_list 
    ;

formal_parameter_list: formal_parameter { $$=new ASTreeNode(astContext,FORMAL_PARAMETER_LIST,$1); }
    | formal_parameter_list COMMA formal_parameter { $$=$1.addSubTree($3); }
    ;

formal_parameter : final_opt type ellipsis_opt variable_declarator_id { $$=new ASTreeNode(astContext,FORMAL_PARAMETER,new ASTree[]{$1,$2,$3,$4}); }
    ;

ellipsis_opt: /* empty */ { $$=null;}
    | ELLIPSIS
    ;

final_opt: /* empty */ { $$=null; }
    | FINAL
    ;


/* 8.4.3 */
/* removed 
method_modifiers: *//* empty */
/*    | method_modifiers method_modifier
    ;

method_modifier: PUBLIC
    | PROTECTED
    | PRIVATE
    | ABSTRACT
    | STATIC
    | FINAL
    | SYNCHRONIZED
    | NATIVE
    | STRICTFP
    ;
*/

/* 8.4.4 */
throws: /* empty */ { $$=null; }
    | THROWS id_type_list { $$=$2.setFirstToken($1); }
    ;

/* 8.4.5 */
method_body: block
    | SEMICOLON
    ;

/* 8.6 */
instance_initializer: block { $$=new ASTreeNode(astContext,INSTANCE_INITIALIZER,$1,$1,new ASTree[]{null,$1}); }
    ;

/* 8.7 */
static_initializer: modifiers block { $$=new ASTreeNode(astContext,STATIC_INITIALIZER,$1,$2); }
    ;

/* 8.8 */
constructor_declaration: modifiers constructor_declarator throws constructor_body { $$=new ASTreeNode(astContext,CONSTRUCTOR_DECLARATION,new ASTree[]{$1,null,null,$2,$3,$4}); }
    | constructor_declarator throws constructor_body { $$=new ASTreeNode(astContext,CONSTRUCTOR_DECLARATION,$1,$3,new ASTree[]{null,null,null,$1,$2,$3}); }
    ;

constructor_declarator: IDENTIFIER L_PAR formal_parameter_list_opt R_PAR { $$=new ASTreeNode(astContext,CONSTRUCTOR_DECLARATOR,$1,$4,new ASTree[]{$1,$3}); }
    ;

/* 8.8.3 */
/* removed 
constructor_modifiers: *//* empty */
/*    | constructor_modifiers constructor_modifier
    ;

constructor_modifier: PUBLIC
    | PROTECTED
    | PRIVATE
    ;
*/

/* 8.8.5 */
/* constructor_body: L_CURLY explicit_constructor_invocation block_statements_opt R_CURLY */
constructor_body: L_CURLY constructor_block_statements R_CURLY { if ($2!=null) $$=$2.setFirstAndLastToken($1,$3); 
                                                                 else $$=new ASTreeNode(astContext,BLOCK_STATEMENTS,$1,$3,(ASTree[])null); }
    ;

/* 8.8.5.1 */
constructor_block_statements: /* empty */ { $$=null; }
    | constructor_block_statements constructor_block_statement { if ($1==null) $$=new ASTreeNode(astContext,BLOCK_STATEMENTS,$2); else $$=$1.addSubTree($2); }
    ;

constructor_block_statement: block_statement
    | THIS L_PAR argument_list_opt R_PAR SEMICOLON { $$=new ASTreeNode(astContext,EXPLICIT_CONSTRUCTOR_INVOCATION,$1,$5,new ASTree[]{null,null,$1,$3}); }
    | SUPER L_PAR argument_list_opt R_PAR SEMICOLON { $$=new ASTreeNode(astContext,EXPLICIT_CONSTRUCTOR_INVOCATION,$1,$5,new ASTree[]{null,null,$1,$3}); }
    | primary DOT SUPER L_PAR argument_list_opt R_PAR SEMICOLON { $$=new ASTreeNode(astContext,EXPLICIT_CONSTRUCTOR_INVOCATION,$1,$7,new ASTree[]{$1,null,$3,$5}); }
    | multi_part_id DOT SUPER L_PAR argument_list_opt R_PAR SEMICOLON { $$=new ASTreeNode(astContext,EXPLICIT_CONSTRUCTOR_INVOCATION,$1,$7,new ASTree[]{$1,null,$3,$5}); }
    ;

/*
explicit_constructor_invocation: 
    | THIS L_PAR argument_list_opt R_PAR SEMICOLON
    | SUPER L_PAR argument_list_opt R_PAR SEMICOLON
    | primary DOT SUPER L_PAR argument_list_opt R_PAR SEMICOLON
    ;
*/

/* 9.1 */
interface_declaration: modifiers INTERFACE IDENTIFIER extends_interfaces interface_body { $$=new ASTreeNode(astContext,INTERFACE_DECLARATION,$1,$5,new ASTree[]{$1,$3,null,null,$4,$5}); }
    | INTERFACE IDENTIFIER extends_interfaces interface_body { $$=new ASTreeNode(astContext,INTERFACE_DECLARATION,$1,$4,new ASTree[]{null,$2,null,null,$3,$4}); }
    ;

/* 9.1.1 */
/* removed */
/* interface_modifiers: *//* empty */
/*    | interface_modifiers interface_modifier
    ;

interface_modifier: PUBLIC 
    | PROTECTED 
    | PRIVATE
    | ABSTRACT
    | STATIC
    | STRICTFP
    ;
*/

/* 9.1.2 */
extends_interfaces: /* empty */ { $$=null; }
    | EXTENDS id_type_list { $$=$2.setFirstToken($1); }
    ;

/* 9.1.3 */
interface_body: L_CURLY interface_member_declarations R_CURLY { if ($2!=null) $$=$2.setFirstAndLastToken($1,$3);
                                                                else $$=new ASTreeNode(astContext,INTERFACE_MEMBER_DECLARATIONS,$1,$3,new ASTree[0]); }
    ;

interface_member_declarations: /* empty */ { $$=null; }
    | interface_member_declarations interface_member_declaration { if ($1==null) $$=new ASTreeNode(astContext,INTERFACE_MEMBER_DECLARATIONS,$2); else $$=$1.addSubTree($2); }
    ;

interface_member_declaration: field_declaration /* constant_declaration */
    | abstract_method_declaration
    | class_declaration
    | interface_declaration
    | SEMICOLON
    ;

/* 9.3 */
/*constant_declaration: modifiers type variable_declarators
    | type variable_declarators
    ;
*/
/* removed 
constant_modifiers: *//* empty */
/*    | constant_modifiers constant_modifier
    ;

constant_modifier: PUBLIC
    | STATIC
    | FINAL
    ;
*/

/* 9.4 */
abstract_method_declaration: modifiers type /* result_type */ method_declarator throws SEMICOLON { $$=new ASTreeNode(astContext,METHOD_DECLARATION,$1,$5,new ASTree[]{$1,null,$2,$3,$4,$5}); }
    | type /* result_type */ method_declarator throws SEMICOLON { $$=new ASTreeNode(astContext,METHOD_DECLARATION,$1,$4,new ASTree[]{null,null,$1,$2,$3,$4}); }
    ;

/* removed
* abstract_method_modifiers: 
*    | abstract_method_modifiers abstract_method_modifier
*    ;
*
* abstract_method_modifier: PUBLIC 
*    | ABSTRACT
*    ;
*/


/* 10.6 */
array_initializer: L_CURLY variable_initializers_opt /* comma_opt  */ R_CURLY { $$=new ASTreeNode(astContext,ARRAY_INITIALIZER,$1,$3,$2); }
    ;

variable_initializers_opt: /* empty */ { $$=null; }
    | variable_initializers
    | variable_initializers COMMA { $$=$1; }
    ;

variable_initializers: variable_initializer
    | variable_initializers COMMA variable_initializer  { if ($1.getType()!=VARIABLE_INITIALIZERS) $$=new ASTreeNode(astContext,VARIABLE_INITIALIZERS,$1,$3);
                                                          else $$=$1.addSubTree($3); }
    ;

/* 14.2 */
block: L_CURLY block_statements_opt R_CURLY { if ($2!=null) $$=$2.setFirstAndLastToken($1,$3);
                                              else $$=new ASTreeNode(astContext,BLOCK_STATEMENTS,$1,$3,(ASTree[])null); }
    ;

block_statements_opt: /* empty */ { $$=null; }
    | block_statements
    ;

block_statements: block_statement { $$=new ASTreeNode(astContext,BLOCK_STATEMENTS,$1); }
    | block_statements block_statement { $$=$1.addSubTree($2); }
    ;

block_statement: local_variable_declaration_statement
    | class_declaration
    | statement
    ;

/* 14.4 */
local_variable_declaration_statement: local_variable_declaration SEMICOLON { $$=$1.setLastToken($2); }
    ;

local_variable_declaration: FINAL type variable_declarators { $$=new ASTreeNode(astContext,LOCAL_VARIABLE_DECLARATION,new ASTree[]{$1,$2,$3}); }
    | type variable_declarators { $$=new ASTreeNode(astContext,LOCAL_VARIABLE_DECLARATION,new ASTree[]{null,$1,$2}); }
    ;

/* 14.5 */
/* modified */
statement: labeled_statement
    | if_statement
    | while_statement
    | for_each_statement
    | for_statement
    | block
    | empty_statement
    | expression_statement
    | switch_statement
    | do_statement
    | break_statement
    | continue_statement
    | return_statement
    | synchronized_statement
    | throw_statement
    | try_statement
    | assert_statement	
    ;


/* 14.6 */
empty_statement: SEMICOLON { $$=new ASTreeNode(astContext,EMPTY_STATEMENT,$1,$1,(ASTree[])null); }
    ;

/* 14.7 */
labeled_statement: IDENTIFIER COLON statement { $$=new ASTreeNode(astContext,LABELED_STATEMENT,$1,$3); }
    ;

/* 14.8 */
expression_statement: statement_expression SEMICOLON { $$=new ASTreeNode(astContext,EXPRESSION_STATEMENT,$1,$2,$1); }
    ;

statement_expression: assignment
    | pre_increment_expression
    | pre_decrement_expression
    | post_increment_expression
    | post_decrement_expression
    | method_invocation
    | class_instance_creation_expression
    ;


/* 14.9 */
if_statement: IF L_PAR expression R_PAR statement { $$=new ASTreeNode(astContext,IF_STATEMENT,$1,$5,new ASTree[]{$3,$5,null}); }
    | IF L_PAR expression R_PAR statement ELSE statement { $$=new ASTreeNode(astContext,IF_STATEMENT,$1,$7,new ASTree[]{$3,$5,$7}); }
    ;

/* 14.10 */
switch_statement: SWITCH L_PAR expression R_PAR switch_block { $$=new ASTreeNode(astContext,SWITCH_STATEMENT,$1,$5,new ASTree[]{$3,$5}); }
    ;

switch_block: L_CURLY switch_block_statement_groups switch_labels_opt R_CURLY { $$=new ASTreeNode(astContext,SWITCH_BLOCK,$1,$4,new ASTree[]{$2,$3}); }
    ;

switch_block_statement_groups: /* empty */ { $$=null; }
    | switch_block_statement_groups switch_block_statement_group { if ($1==null) $$=new ASTreeNode(astContext,SWITCH_BLOCK_STATEMENT_GROUPS,$2); else $$=$1.addSubTree($2); }
    ;

switch_block_statement_group: switch_labels block_statements { $$=new ASTreeNode(astContext,SWITCH_BLOCK_STATEMENT_GROUP,$1,$2); }
    ;

switch_labels_opt: /* empty */ { $$=null; }
    | switch_labels
    ;

switch_labels: switch_label
    | switch_labels switch_label { if ($1.getType()!=SWITCH_LABELS) $$=new ASTreeNode(astContext,SWITCH_LABELS,$1,$2); else $$=$1.addSubTree($2); }
    ;

switch_label: CASE constant_expression COLON { $$=new ASTreeNode(astContext,SWITCH_LABEL,$1,$3,new ASTree[]{$2}); }
    | DEFAULT COLON { $$=new ASTreeNode(astContext,SWITCH_LABEL,$1,$2,new ASTree[]{null}); }
    ;

/* 14.11 */
while_statement: WHILE L_PAR expression R_PAR statement { $$=new ASTreeNode(astContext,WHILE_STATEMENT,$1,$5,new ASTree[]{$3,$5}); }
    ;

/* 14.12 */
do_statement: DO statement WHILE L_PAR expression R_PAR SEMICOLON { $$=new ASTreeNode(astContext,DO_STATEMENT,$1,$7,new ASTree[]{$2,$5}); }
    ;

/* jsr 201 enhanced for loop */
for_each_statement: FOR L_PAR for_init COLON expression R_PAR statement { 
        ASTree[] fparts=$3.getSubTrees();
        ASTree fpar=new ASTreeNode(astContext,FORMAL_PARAMETER,new ASTree[]{fparts[0],fparts[1],null,fparts[2]});
        $$=new ASTreeNode(astContext,FOR_EACH_STATEMENT,$1,$7,new ASTree[]{fpar,$5,$7}); }
    ;

/* 14.13 */
for_statement: FOR L_PAR for_init SEMICOLON expression_opt SEMICOLON for_update R_PAR statement { $$=new ASTreeNode(astContext,FOR_STATEMENT,$1,$9,new ASTree[]{$3,$5,$7,$9}); }
    ;

for_init: /* empty */ { $$=null; }
    | statement_expression_list
    | local_variable_declaration
    ;

expression_opt: /* empty */ { $$=null; }
    | expression 
    ;

for_update: /* empty */ { $$=null; }
    | statement_expression_list
    ;

statement_expression_list: statement_expression
    | statement_expression_list COMMA statement_expression { if ($1.getType()!=STATEMENT_EXPRESSION_LIST) $$=new ASTreeNode(astContext,STATEMENT_EXPRESSION_LIST,$1,$3);
                                                     else $$=$1.addSubTree($3); } 
    ;

/* 14.14 */
break_statement: BREAK identifier_opt SEMICOLON { $$=new ASTreeNode(astContext,BREAK_STATEMENT,$1,$3,new ASTree[]{$2}); }
    ;

identifier_opt: /* empty */ { $$=null; }
    | IDENTIFIER
    ;

/* 14.15 */
continue_statement: CONTINUE identifier_opt SEMICOLON { $$=new ASTreeNode(astContext,CONTINUE_STATEMENT,$1,$3,new ASTree[]{$2}); }
    ;


/* 14.16 */
return_statement: RETURN expression_opt SEMICOLON { $$=new ASTreeNode(astContext,RETURN_STATEMENT,$1,$3,new ASTree[]{$2}); }
    ;

/* 14.17 */
throw_statement: THROW expression SEMICOLON { $$=new ASTreeNode(astContext,THROW_STATEMENT,$1,$3,new ASTree[]{$2}); }
    ;

/* 14.18 */
synchronized_statement:  SYNCHRONIZED L_PAR expression R_PAR block { $$=new ASTreeNode(astContext,SYNCHRONIZE_STATEMENT,$1,$5,new ASTree[]{$3,$5}); }
    ;

/* 14.19 */
try_statement: TRY block catches { $$=new ASTreeNode(astContext,TRY_STATEMENT,$1,$3,new ASTree[]{$2,$3,null}); }
    | TRY block catches_opt finally { $$=new ASTreeNode(astContext,TRY_STATEMENT,$1,$4,new ASTree[]{$2,$3,$4}); }
    ;

catches_opt: /* empty */ { $$=null; }
    | catches
    ;

catches: catch_clause
    | catches catch_clause { if ($1.getType()!=CATCHES) $$=new ASTreeNode(astContext,CATCHES,$1,$2); else $$=$1.addSubTree($2); }
    ;

catch_clause: CATCH L_PAR formal_parameter R_PAR block { $$=new ASTreeNode(astContext,CATCH_CLAUSE,$1,$5,new ASTree[]{$3,$5}); }
    ;

finally: FINALLY block { $$=$2; }
    ;

/* 14.xx */
assert_statement: ASSERT expression SEMICOLON { $$=new ASTreeNode(astContext,ASSERT_STATEMENT,$1,$3,new ASTree[]{$2,null}); }
    | ASSERT expression COLON expression SEMICOLON { $$=new ASTreeNode(astContext,ASSERT_STATEMENT,$1,$5,new ASTree[]{$2,$4}); }
    ;

/* 15.8 */
primary: primary_no_new_array
    | array_creation_expression
    ;

primary_no_new_array: literal 
/*   | type DOT CLASS */
/*   | VOID DOT CLASS */
    | multi_part_id DOT CLASS { $$ = new ASTreeNode(astContext,PRIMARY_CLASS,$1,$3,new ASTree[]{$1}); }
    | multi_part_id dims DOT CLASS { $$ = new ASTreeNode(astContext,PRIMARY_CLASS,$1,$4,new ASTree[]{new ASTreeNode(astContext,REFERENCE_TYPE,$1,$2)}); }
    | primitive_type DOT CLASS { $$ = new ASTreeNode(astContext,PRIMARY_CLASS,$1,$3,new ASTree[]{$1}); }
    | primitive_type dims DOT CLASS { $$ = new ASTreeNode(astContext,PRIMARY_CLASS,$1,$4,new ASTree[]{new ASTreeNode(astContext,REFERENCE_TYPE,$1,$2)}); }

    | THIS { $$ = new ASTreeNode(astContext,PRIMARY_THIS,$1,$1,(ASTree[])null); }
    | multi_part_id DOT THIS { $$ = new ASTreeNode(astContext,PRIMARY_THIS,$1,$3,$1); }
    | L_PAR expression R_PAR { $$ = new ASTreeNode(astContext,COMPLEX_EXPRESSION,$1,$3,$2); }
    | class_instance_creation_expression
    | field_access
    | method_invocation
    | array_access
    ;

/* 15.8.1 */
literal: INT_LIT
    | FLOAT_LIT
    | BOOL_LIT
    | CHAR_LIT
    | STRING_LIT
    | NULL_LIT
    ;

/* 15.9 */
class_instance_creation_expression: NEW multi_part_id L_PAR argument_list_opt R_PAR class_body_opt { $$=new ASTreeNode(astContext,CLASS_INSTANCE_CREATION_EXPRESSION,$1,$6==null?$5:$6,new ASTree[]{null,null,$2,$4,$6}); }
    | primary DOT NEW IDENTIFIER L_PAR argument_list_opt R_PAR class_body_opt { $$=new ASTreeNode(astContext,CLASS_INSTANCE_CREATION_EXPRESSION,$1,$8==null?$7:$8,new ASTree[]{$1,null,$4,$6,$8}); }
    | multi_part_id DOT NEW IDENTIFIER L_PAR argument_list_opt R_PAR class_body_opt { $$=new ASTreeNode(astContext,CLASS_INSTANCE_CREATION_EXPRESSION,$1,$8==null?$7:$8,new ASTree[]{$1,null,$4,$6,$8}); }
    ;

argument_list_opt: /* empty */ { $$=null; }
    | argument_list
    ;

argument_list: expression
    | argument_list COMMA expression { if ($1.getType()!=ARGUMENT_LIST) $$=new ASTreeNode(astContext,ARGUMENT_LIST,$1,$3); else $$=$1.addSubTree($3); }
    ;

class_body_opt: /* empty */ { $$=null; }
    | class_body
    ;

/* 15.10 */
array_creation_expression: NEW primitive_type dim_exprs dims { $$=new ASTreeNode(astContext,ARRAY_CREATION_EXPRESSION,$1,$4,new ASTree[]{$2,$3,$4,null}); }
    | NEW primitive_type dim_exprs { $$=new ASTreeNode(astContext,ARRAY_CREATION_EXPRESSION,$1,$3,new ASTree[]{$2,$3,null,null}); }
    | NEW multi_part_id dim_exprs dims { $$=new ASTreeNode(astContext,ARRAY_CREATION_EXPRESSION,$1,$4,new ASTree[]{$2,$3,$4,null}); }
    | NEW multi_part_id dim_exprs { $$=new ASTreeNode(astContext,ARRAY_CREATION_EXPRESSION,$1,$3,new ASTree[]{$2,$3,null,null}); }
    | NEW primitive_type dims array_initializer { $$=new ASTreeNode(astContext,ARRAY_CREATION_EXPRESSION,$1,$4,new ASTree[]{$2,null,$3,$4}); }
    | NEW multi_part_id dims array_initializer { $$=new ASTreeNode(astContext,ARRAY_CREATION_EXPRESSION,$1,$4,new ASTree[]{$2,null,$3,$4}); }
    ;

dim_exprs: dim_expr { $$=new ASTreeNode(astContext,DIM_EXPRS,$1); $$.setFirstToken($1.getFirstToken()-1); $$.setLastToken($1.getLastToken()+1); }
    | dim_exprs dim_expr { $$=$1.addSubTree($2); $$.setLastToken($2.getLastToken()+1); }
    ;

dim_expr: L_BRACKET expression R_BRACKET { $$ = $2; }
    ;

dims: L_BRACKET R_BRACKET { $$=new ASTreeNode(astContext,DIMS,$1,$2,(ASTree[])null); }
    | dims L_BRACKET R_BRACKET { $$=$1.setLastToken($3); }
    ;

/* 15.11 */
field_access:  primary DOT IDENTIFIER { $$= new ASTreeNode(astContext,FIELD_ACCESS,$1,$3,new ASTree[]{$1,null,$3}); }
    | SUPER DOT IDENTIFIER { $$= new ASTreeNode(astContext,FIELD_ACCESS,$1,$3,new ASTree[]{null,$1,$3}); }
    | multi_part_id DOT SUPER DOT IDENTIFIER { $$= new ASTreeNode(astContext,FIELD_ACCESS,$1,$5,new ASTree[]{$1,$3,$5}); }
    ;

/* 15.12 */
method_invocation: multi_part_id DOT IDENTIFIER L_PAR argument_list_opt R_PAR { $$ = new ASTreeNode(astContext,METHOD_INVOCATION,$1,$6,new ASTree[]{$1,null,null,$3,$5}); }
    | IDENTIFIER L_PAR argument_list_opt R_PAR { $$ = new ASTreeNode(astContext,METHOD_INVOCATION,$1,$4,new ASTree[]{null,null,null,$1,$3}); }
    | primary DOT IDENTIFIER L_PAR argument_list_opt R_PAR { $$ = new ASTreeNode(astContext,METHOD_INVOCATION,$1,$6,new ASTree[]{$1,null,null,$3,$5}); }
    | SUPER DOT IDENTIFIER L_PAR argument_list_opt R_PAR { $$ = new ASTreeNode(astContext,METHOD_INVOCATION,$1,$6,new ASTree[]{null,$1,null,$3,$5}); }
    | multi_part_id DOT SUPER DOT IDENTIFIER L_PAR argument_list_opt R_PAR { $$ = new ASTreeNode(astContext,METHOD_INVOCATION,$1,$8,new ASTree[]{$1,$3,null,$5,$7}); }
    ;

/* 15.13 */
array_access: multi_part_id L_BRACKET expression R_BRACKET { $$=new ASTreeNode(astContext,ARRAY_ACCESS,$1,$4,new ASTree[]{$1,$3}); }
    | primary_no_new_array L_BRACKET expression R_BRACKET { $$=new ASTreeNode(astContext,ARRAY_ACCESS,$1,$4,new ASTree[]{$1,$3}); }
    ;

/* 15.14 */
postfix_expression: primary
    | multi_part_id 
    | post_increment_expression
    | post_decrement_expression
    ;

/* 15.14.1 */
post_increment_expression: postfix_expression INCREMENT { $$=new ASTreeNode(astContext,POSTFIX_EXPRESSION,$1,$2); }
    ;

/* 15.14.2 */
post_decrement_expression: postfix_expression DECREMENT { $$=new ASTreeNode(astContext,POSTFIX_EXPRESSION,$1,$2); }
    ;

/* 15.15 */
unary_expression: pre_increment_expression
    | pre_decrement_expression
    | PLUS unary_expression { $$=new ASTreeNode(astContext,PREFIX_EXPRESSION,$1,$2); }
    | MINUS unary_expression { $$=new ASTreeNode(astContext,PREFIX_EXPRESSION,$1,$2); }
    | unary_expression_not_plus_minus
    ;

pre_increment_expression: INCREMENT unary_expression { $$=new ASTreeNode(astContext,PREFIX_EXPRESSION,$1,$2); }
    ;

pre_decrement_expression: DECREMENT unary_expression { $$=new ASTreeNode(astContext,PREFIX_EXPRESSION,$1,$2); }
    ;

unary_expression_not_plus_minus: postfix_expression
    | COMP unary_expression { $$=new ASTreeNode(astContext,PREFIX_EXPRESSION,$1,$2); }
    | NOT unary_expression { $$=new ASTreeNode(astContext,PREFIX_EXPRESSION,$1,$2); }
    | cast_expression
    ;

/* 15.16 */
cast_expression: L_PAR primitive_type dims R_PAR unary_expression { $$=new ASTreeNode(astContext,CAST_EXPRESSION,$1,$5,new ASTree[]{new ASTreeNode(astContext,REFERENCE_TYPE,$2,$3),$5}); }
    | L_PAR primitive_type R_PAR unary_expression { $$=new ASTreeNode(astContext,CAST_EXPRESSION,$1,$4,new ASTree[]{$2,$4}); }
    | L_PAR expression R_PAR unary_expression_not_plus_minus { $$=new ASTreeNode(astContext,CAST_EXPRESSION,$1,$4,new ASTree[]{$2,$4}); }
    | L_PAR multi_part_id dims R_PAR unary_expression_not_plus_minus { $$=new ASTreeNode(astContext,CAST_EXPRESSION,$1,$5,new ASTree[]{new ASTreeNode(astContext,REFERENCE_TYPE,$2,$3),$5}); }
    ;

/* 15.17 */
multicaptive_expression: unary_expression
    | multicaptive_expression MULTI unary_expression { $$=new ASTreeNode(astContext,INFIX_EXPRESSION,new ASTree[]{$1,$2,$3}); }
    | multicaptive_expression DIV unary_expression { $$=new ASTreeNode(astContext,INFIX_EXPRESSION,new ASTree[]{$1,$2,$3}); }
    | multicaptive_expression MOD unary_expression { $$=new ASTreeNode(astContext,INFIX_EXPRESSION,new ASTree[]{$1,$2,$3}); }
    ;

/* 15.18 */
additive_expression: multicaptive_expression
    | additive_expression PLUS multicaptive_expression { $$=new ASTreeNode(astContext,INFIX_EXPRESSION,new ASTree[]{$1,$2,$3}); }
    | additive_expression MINUS multicaptive_expression { $$=new ASTreeNode(astContext,INFIX_EXPRESSION,new ASTree[]{$1,$2,$3}); }
    ;

/* 15.19 */
shift_expression: additive_expression 
    | shift_expression L_SHIFT additive_expression { $$=new ASTreeNode(astContext,INFIX_EXPRESSION,new ASTree[]{$1,$2,$3}); }
    | shift_expression R_SHIFT additive_expression { $$=new ASTreeNode(astContext,INFIX_EXPRESSION,new ASTree[]{$1,$2,$3}); }
    | shift_expression UR_SHIFT additive_expression { $$=new ASTreeNode(astContext,INFIX_EXPRESSION,new ASTree[]{$1,$2,$3}); }
    ;

/* 15.20 */
relational_expression: shift_expression
    | relational_expression LT shift_expression { $$=new ASTreeNode(astContext,INFIX_EXPRESSION,new ASTree[]{$1,$2,$3}); }
    | relational_expression GT shift_expression { $$=new ASTreeNode(astContext,INFIX_EXPRESSION,new ASTree[]{$1,$2,$3}); }
    | relational_expression LTE shift_expression { $$=new ASTreeNode(astContext,INFIX_EXPRESSION,new ASTree[]{$1,$2,$3}); }
    | relational_expression GTE shift_expression { $$=new ASTreeNode(astContext,INFIX_EXPRESSION,new ASTree[]{$1,$2,$3}); }
    | relational_expression INSTANCEOF reference_type { $$=new ASTreeNode(astContext,INFIX_EXPRESSION,new ASTree[]{$1,$2,$3}); }
    ;

/* 15.21 */
equality_expression: relational_expression
    | equality_expression EQ relational_expression { $$=new ASTreeNode(astContext,INFIX_EXPRESSION,new ASTree[]{$1,$2,$3}); }
    | equality_expression NEQ relational_expression { $$=new ASTreeNode(astContext,INFIX_EXPRESSION,new ASTree[]{$1,$2,$3}); }
    ;

/* 15.22 */
and_expression: equality_expression
    | and_expression AND equality_expression { $$=new ASTreeNode(astContext,INFIX_EXPRESSION,new ASTree[]{$1,$2,$3}); }
    ;

exclusive_or_expression: and_expression
    | exclusive_or_expression XOR and_expression { $$=new ASTreeNode(astContext,INFIX_EXPRESSION,new ASTree[]{$1,$2,$3}); }
    ;

inclusive_or_expression: exclusive_or_expression
    | inclusive_or_expression OR exclusive_or_expression { $$=new ASTreeNode(astContext,INFIX_EXPRESSION,new ASTree[]{$1,$2,$3}); }
    ;

/* 15.23 */
conditional_and_expression: inclusive_or_expression
    | conditional_and_expression BOOL_AND inclusive_or_expression { $$=new ASTreeNode(astContext,INFIX_EXPRESSION,new ASTree[]{$1,$2,$3}); }
    ;

/* 15.24 */
conditional_or_expression: conditional_and_expression
    | conditional_or_expression BOOL_OR conditional_and_expression { $$=new ASTreeNode(astContext,INFIX_EXPRESSION,new ASTree[]{$1,$2,$3}); }
    ;

/* 15.25 */
conditional_expression: conditional_or_expression
    | conditional_or_expression QUESTION expression COLON conditional_expression { $$=new ASTreeNode(astContext,CONDITIONAL_EXPRESSION,$1,$5,new ASTree[]{$1,$3,$5}); }
    ;

/* 15.26 */
assignment_expression: conditional_expression
    | assignment
    ;

assignment: left_hand_side assignment_operator assignment_expression { $$ = new ASTreeNode(astContext,ASSIGNMENT,new ASTree[]{$1,$2,$3}); }
    ;

left_hand_side: multi_part_id
    | field_access
    | array_access
    ;

assignment_operator: ASSIGN
    | PLUS_ASSIGN
    | MINUS_ASSIGN
    | MULTI_ASSIGN
    | DIV_ASSIGN
    | AND_ASSIGN
    | OR_ASSIGN
    | XOR_ASSIGN
    | MOD_ASSIGN
    | L_SHIFT_ASSIGN
    | R_SHIFT_ASSIGN   
    | UR_SHIFT_ASSIGN
    ;

/* 15.27 */
expression: assignment_expression
    ;

/* 15.28 */
constant_expression: expression
    ;

modifiers: modifier { $$=new ASTreeNode(astContext,MODIFIERS,$1); }
    | modifiers modifier { $$=$1.addSubTree($2); }
    ;

modifier: PUBLIC
    | PROTECTED
    | PRIVATE
    | ABSTRACT
    | STATIC
    | FINAL
    | SYNCHRONIZED
    | NATIVE
    | STRICTFP
    | TRANSIENT
    | VOLATILE
    ;

multi_part_id: IDENTIFIER 
    | multi_part_id DOT IDENTIFIER { $$=new ASTreeNode(astContext,MULTI_PART_ID,$1,$3,new ASTree[]{$1,$3,null}); }
    ;

%%

private Scanner scanner;
private ASTContext astContext;

private int yylex() {
    try {
        int type=scanner.yylex();
        ((ScannerToken)yylval).setContext(astContext);
        return type;
    }
    catch (IOException e) {
        //System.err.println("Error: "+e);
    }
    return -1;
}

private void yyerror(String s) {
    System.err.println("YYError: "+s);
}

public Parser(ASTContext context, Reader in, String filename) {
    scanner = new Scanner(in);
    scanner.setParser(this);
    astContext=context;
}

public Parser(InputStream in) {
    scanner = new Scanner(in);
    scanner.setParser(this);
}

public static void main(String argv[]) {
    if (argv.length == 0) {
        System.out.println("Usage : java Scanner <inputfile>");
    }
    else {
        for (int i = 0; i < argv.length; i++) {
            Parser parser = null;
            try {
                int status;

                System.out.println("File: "+argv[i]);
                parser = new Parser(null, new FileReader(argv[i]), argv[i] );
                //		  parser.yydebug=true;
                status=parser.yyparse();
                if (status!=0)
                    System.exit(status);
            }
            catch (FileNotFoundException e) {
                System.out.println("File not found : \""+argv[i]+"\"");
            }
            catch (IOException e) {
                System.out.println("IO error scanning file \""+argv[i]+"\"");
                System.out.println(e);
            }
            catch (Exception e) {
                System.out.println("Unexpected exception:");
                e.printStackTrace();
            }
        }
    }
}

public ASTree getASTree() {
    return yyval;
}

public Token[] getTokens() {
    return scanner.getTokens();
}

public int parse(boolean doAttribution) throws CompilerException {
    return yyparse();
}

public int doAttribution() {
    return 0;
}
