/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * Token.java
 *
 * Created on January 7, 2002, 3:06 PM
 */

package org.netbeans.lib.java.parser;

/**
 *
 * @author  Tomas Hurka
 */
public interface Token extends ASTree {
            
    public int getStartOffset();
    
    public int getEndOffset();
    
    public Token[] getPadding();
    
    public Object getValue();

    /**
     * Returns the scanner's deprecatedFlag setting when this token
     * was created.  Note:  this does not indicate whether the structure
     * associated with this token is actually deprecated, only the
     * scanner's state.  This is necessary so that accurate deprecation
     * information can be returned after the scanner instance is released
     * from a token array.
     */
    public boolean getDeprecatedFlag();
}
