/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.java.parser;

import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.Token;

/**
 * Java parser interface
 */
public interface JParser {
    /**
      * Return the top node of a parsed source file, or null if
      * source wasn't successfully parsed.
      */
    ASTree getASTree();

    /**
     * Return the array of tokens from a parsed source file, or null
     * if source wasn't successfully scanned.
     */
    Token[] getTokens();

    /**
      * Execute a parser.
      *
      * @param doAttribution if true, execute attribution phase after parsing
      * @return 0 (zero) if successful.
      */
    int parse(boolean doAttribution) throws CompilerException;
}
