/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * ASTree.java
 *
 * Created on February 4, 2002, 3:05 PM
 */

package org.netbeans.lib.java.parser;

/**
 *
 * @author  Tomas Hurka
 */
class ASTreeNode extends ASTClass implements ASTreeTypes {
    
    private int firstToken,lastToken;    
    ASTree subTrees[];   
        
    ASTreeNode(ASTContext context,int type, ASTree first, ASTree last, ASTree[] sub) {
        super(context,type);
        firstToken=first.getFirstToken();
        lastToken=last.getLastToken();
        subTrees=sub;
    }

    ASTreeNode(ASTContext context,int type, ASTree first, ASTree last, ASTree sub) {
        this(context,type,first,last,new ASTree[]{sub});
    }
        
    ASTreeNode(ASTContext context,int type, ASTree token) {
        super(context,type);
        subTrees=new ASTree[]{token};
        firstToken=token.getFirstToken();
        lastToken=token.getLastToken();
    }

    ASTreeNode(ASTContext context,int type, ASTree[] sub) {
        super(context,type);
        subTrees=sub;
        computeBounds();
    }
    
    ASTreeNode(ASTContext context,int type, ASTree leftAST, ASTree rightAST) {
        super(context,type);
        subTrees=new ASTree[]{leftAST,rightAST};
        computeBounds();
    }

    private void computeBounds() {
        int i,j;
        
        for (i=0;i<subTrees.length;i++) {
            if (subTrees[i]!=null) {
                firstToken=subTrees[i].getFirstToken();
                break;
            }
        }
        for (j=subTrees.length-1;j>=i;j--) {
            if (subTrees[j]!=null) {
                lastToken=subTrees[j].getLastToken();
                break;
            }
        }
    }

    final ASTClass setLastToken(ASTree token) {
        lastToken = token.getLastToken();
        return this;
    }   
    
    final ASTClass setLastToken(int tokenIndex) {
        lastToken = tokenIndex;
        return this;
    }

    /** Getter for property lastToken.
     * @return Value of property lastToken.
     */
    public final int getLastToken() {
        return lastToken;
    }
    
    final ASTClass setFirstToken(ASTree token) {
        firstToken = token.getFirstToken();
        return this;
    }
    
    final ASTClass setFirstToken(int tokenIndex) {
        firstToken = tokenIndex;
        return this;
    }

    public final int getFirstToken() {
        return firstToken;
    }
    
    final ASTClass addSubTree(ASTree sub) {
        if (subTrees!=null) {
            int size=subTrees.length;
            ASTree trees[]=new ASTree[size+1];

            System.arraycopy(subTrees,0,trees,0,size);
            trees[size]=sub;
            subTrees=trees;
        } else
            subTrees=new ASTree[]{sub};
        if (sub!=null)
            lastToken=sub.getLastToken();
        return this;
    }
  
    final ASTClass setFirstAndLastToken(ASTree first, ASTree last) {
        firstToken = first.getFirstToken();
        lastToken=last.getLastToken();
        return this;
    }
        
    public final String toString() {
        String text="ASTreeNode Type:"+getType()+"\n{\n";
        int i;
        
        if (subTrees!=null) {
            for (i=0;i<subTrees.length;i++) {
                String subText;
                ASTree t=subTrees[i];

                if (t!=null)
                    subText=t.toString();
                else
                    subText="NULL";
                text+=subText+"\n";
            }
        }
        return text+"}\n";
    }    

    public final ASTree[] getSubTrees() {
        return subTrees;
    }
    
}
