/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.java.parser;

/**
 *
 * @author  tball
 */
public interface ASTContext {
    ASTree getRootTree();
    String getText(ASTree tree);
    String getText(Token token);
    Token getToken(int index);
    ASTree getParent(ASTree tree);

    /**
     * Return the -source flag javac would use to compile code in this
     * context, such as "1.5".
     */
    String getSourceLevel();
    
    /**
     * Return current classpath. Classpath elements are separated by colon.
     * (e.g. '/opt/projects/module/src:/opt/projects/lib/src')
     *
     * @return String classpath elements (roots) separated by colon.
     */
    String getClassPath();
    
    /**
     * Returns object which is responsible for handling errors encountered
     * while parsing current source file
     *
     * @return instance of ErrConsumer or null if errors does not need to be 
     * processed
     */
    ErrConsumer getErrorConsumer();
}
