/*
* The contents of this file are subject to the terms of the Common Development
* and Distribution License (the License). You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the License at http://www.netbeans.org/cddl.html
* or http://www.netbeans.org/cddl.txt.
* 
* When distributing Covered Code, include this CDDL Header Notice in each file
* and include the License file at http://www.netbeans.org/cddl.txt.
* If applicable, add the following below the CDDL Header, with the fields
* enclosed by brackets [] replaced by your own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* The Original Software is NetBeans. The Initial Developer of the Original
* Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
* Microsystems, Inc. All Rights Reserved.
*/
/*
 * Markup.java
 *
 * Created on September 20, 2004, 10:47 PM
 */

package org.netbeans.modules.java.navigation.strings;

import java.util.*;

/**
 * Holds markup information for an instance of WeightedString. This could be implemented directly there, but it's a
 * little clearer this way.
 *
 * @author Tim Boudreau
 */

final class Markup {

    private int[] markupIndices = new int[ 5 ];
    private int[] markupTypes = new int[ 5 ];
    private int markupCount = 0;
    private int lastMarkupPosition = -1;
    private int usedTypes = 0;

    /**
     * Creates a new instance of Markup
     */
    Markup () {
    }

    public int allMarkupTypes () {
        return usedTypes;
    }

    private void ensureCapacity () {
        if ( markupCount == markupIndices.length - 1 ) {
            int[] newPositions = new int[ markupIndices.length * 2 ];
            int[] newTypes = new int[ newPositions.length ];
            System.arraycopy ( markupIndices, 0, newPositions, 0, markupIndices.length );
            System.arraycopy ( markupTypes, 0, newTypes, 0, markupTypes.length );
            markupIndices = newPositions;
            markupTypes = newTypes;
        }
    }

    public void clear () {
        markupCount = 0;
        Arrays.fill ( markupTypes, 0 );
        Arrays.fill ( markupIndices, Integer.MAX_VALUE );
        lastMarkupPosition = -1;
        usedTypes = 0;
    }

    public boolean isEmpty () {
        return usedTypes == 0;
    }

    public void start (int position, int type) {
        boolean isEnd = type == 0;
        ensureCapacity ();

        if ( markupCount > 0 && position == markupIndices[ markupCount - 1 ] ) {
            markupTypes[ markupCount - 1 ] |= type;
        } else {
            assert position > lastMarkupPosition;
            markupTypes[ markupCount ] = type;
            markupIndices[ markupCount ] = position;
            lastMarkupPosition = position;
            markupCount++;
        }
        usedTypes |= type;
    }

    public void end (int position) {
        start ( position, 0 );
    }

    public int get (int position) {
        if ( !isEmpty () ) {
            for ( int i = markupCount - 1; i >= 0; i-- ) {
                int idx = markupIndices[ i ];
                if ( position >= idx ) {
                    return markupTypes[ i ];
                }
            }
        }
        return 0;
    }
}
