/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * Abbreviator.java
 *
 * Created on September 20, 2004, 2:36 PM
 */

package org.netbeans.modules.java.navigation.spi.strings;
import org.openide.util.*;
import org.netbeans.modules.java.navigation.strings.AbbreviatorImpl;

/**
 * Abbreviation engine which can weight the characters in a string to decide which ones may be omitted without making
 * the string unintelligable. A default implementation is supplied by the navigator module; it is possible to override
 * this by registering a different implementation in the default lookup (via META-INF/Services).
 *
 * @author Tim Boudreau
 */
public abstract class Abbreviator {
    private static Abbreviator INSTANCE = null;

    protected Abbreviator () {
    }

    /**
     * Get the default abbreviation engine.
     */
    public static final Abbreviator getInstance () {
        //TODO: For localization, look up a default instance by locale
        if ( INSTANCE == null ) {
            INSTANCE = (Abbreviator) Lookup.getDefault ().lookup ( Abbreviator.class );
        }
        if ( INSTANCE == null ) {
            INSTANCE = new AbbreviatorImpl ();
        }
        return INSTANCE;
    }

    /**
     * Generate an array of weights between 0.0f and 1.0f representing the relative importance of the characters in the
     * passed character array, and taking into account the passed overal importance value.
     * <p/>
     * The returned array may be greater than the length of the passed character array and is not guaranteed to remain
     * unmodified after subsequent calls.
     */
    public abstract float[] process (char[] c, float importance);

    /**
     * Get an array of 10 lengths, representing the length of the character array when filtering out characters with
     * weights lower that the array index / 10.  In other words, if you pass "hello" to <code>process</code> and get
     * back
     * <pre>
     * h     e      l      l      o
     * 0.9   0.2    0.5    0.1    0.2
     * </pre>
     * then <ul><li>getLengthsForLastRun[10] == 0 (no weights > 0.9)</li> <li>getLengthsForLastRun[6..9] == 1 (one
     * character with a weight of >= 0.6)</lli> <li>getLengthsForLastRun[5] == 2 (two characters with a weight of >=
     * 0.5)</li> <li>getLengthsForLastRun[2] == 4 (length of "helo")</li> </ul> and so forth.
     *
     * @return an array of string lengths by weight
     */
    public abstract int[] getLengthsForLastRun ();

    /**
     * Get the highest character weight from the last call to process().
     */
    public abstract float getMaxWeightForLastRun ();

    /**
     * get the lowest character weight from the last call to process().
     */
    public abstract float getMinWeightForLastRun ();

}
