/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * ModelProvider.java
 *
 * Created on September 11, 2004, 8:20 PM
 */

package org.netbeans.modules.java.navigation.spi;

import org.openide.loaders.*;

import javax.swing.*;

/**
 * An object which provides a list or tree model for a given DataObject. In order to allow the user to select from
 * multiple views, each has a display name and icon.
 * <p/>
 * The navigator module allows ModelProviders to be registered via module layers, in the system file system.  Example:
 * <pre>
 * &lt;folder name="navigator"&gt;
 * &lt;folder name="hierarchy"&gt;
 * <p/>
 * &lt;file name="com-foo-mymodule-javamodel"&gt;
 * &lt;attr name="instanceClass" stringvalue="com.foo.mymodule.MyModelProvider"/&gt;
 * &lt;attr name="classes" stringvalue="org.netbeans.modules.java.JavaDataObject"/&gt;
 * &lt;/file&gt;
 * <p/>
 * &lt;/folder&gt;
 * &lt;/folder&gt;
 * </pre>
 * <p/>
 * The <code>instanceClass</code> attribute should be the fully qualified class name of the <code>ModelProvider</code>
 * supplied.  The <code>classes</code> may be either a single, fully-qualified DataObject subclass name, or a
 * comma-delimited list of such fully-qualified class names.
 *
 * @author Tim Boudreau
 */
public abstract class ModelProvider {
    /**
     * Type indicating a list model will be provided
     */
    public static final int TYPE_LIST = 1;
    /**
     * Type indicating a tree model will be provided
     */
    public static final int TYPE_TREE = 2;

    //PENDING TYPE_NONE for "I can't deal with this data object"
    private final Icon icon;
    private final String name;

    /**
     * Create a model provider with the specified icon and localized display name
     */
    protected ModelProvider (Icon icon, String displayName) {
        this.icon = icon;
        this.name = displayName;
    }

    /**
     * Return either TYPE_LIST or TYPE_TREE, depending on the view type preferred.
     */
    public abstract int typeof (DataObject o);

    /**
     * Create a list model representing the children of this object. Throws an UnsupportedOperationException if
     * <code>typeOf</code> would return TYPE_TREE for this object.
     */
    public abstract NavigatorListModel createListModel (DataObject o);

    /**
     * Create a list model representing the children of this object. Throws an UnsupportedOperationException if
     * <code>typeOf</code> would return TYPE_LIST for this object.
     */
    public abstract NavigatorTreeModel createTreeModel (DataObject o);

    /**
     * Get an icon to be used to display this ModelProvider to the user
     */
    public final Icon getIcon () {
        return icon;
    }

    /**
     * Get a localized display name for this ModelProvider
     */
    public final String getDisplayName () {
        return name;
    }
}
