/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * ExtListDataEvent.java
 *
 * Created on September 17, 2004, 3:07 PM
 */

package org.netbeans.modules.java.navigation.spi;

import javax.swing.event.*;
import java.util.*;

/**
 * An extension to ListDataEvent that allows the former contents of the list model to be found, making it possible to
 * generate an accurate TreeModelEvent from one or more ExtListDataEvents.
 *
 * @author Tim Boudreau
 */
public final class ExtListDataEvent extends ListDataEvent {
    private List old = null;
    private List nue = null;

    public ExtListDataEvent (NavigatorListModel mdl, int type, int start, int end) {
        super ( mdl, type, start, end );
    }

    public List getOldContents () {
        if ( getType () == INTERVAL_REMOVED && ( old == null || old.size () == 0 ) ) {
            throw new IllegalStateException ( "Old contents not supplied" );
        }
        return old;
    }

    public List getNewContents () {
        if ( getType () == INTERVAL_ADDED && ( nue == null || nue.size () == 0 ) ) {
            throw new IllegalStateException ( "New contents not supplied" );
        }
        return nue;
    }

    public void setContents (List old, List nue) {
        if ( getType () == INTERVAL_ADDED && ( nue == null || nue.size () == 0 ) ) {
            throw new IllegalArgumentException ( "For an INTERVAL_ADDED event, " +
                    " the new data list must be non null and size > 0 :" + nue );
        }
        if ( getType () == INTERVAL_REMOVED && ( old == null || old.size () == 0 ) ) {
            throw new IllegalArgumentException ( "For an INTERVAL_REMOVED event, " +
                    " the new data list must be non null and size > 0 :" + old );
        }
        this.old = old;
        this.nue = nue;
    }

    public String toString () {
        StringBuffer sb = new StringBuffer ( super.toString () );
        sb.append ( " old: " );
        sb.append ( old );
        sb.append ( " new: " );
        sb.append ( nue );
        return sb.toString ();
    }
}
