/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * DisplayProvider.java
 *
 * Created on September 11, 2004, 8:03 PM
 */

package org.netbeans.modules.java.navigation.spi;


import javax.swing.*;
import org.netbeans.modules.java.navigation.spi.strings.WeightedString;

/**
 * Interface for things that provide display information to trees, tables or lists.  Supports WeightedString to enable
 * emphasis/deemphasis, and limiting the information displayed to the most important if the display area is limited.
 * <p/>
 * Typically this interface will not be implemented as such, but rather one of the model interfaces which aggregate this
 * interface into themselves.
 *
 * @author Tim Boudreau
 * @see NavigatorListModel
 * @see NavigatorTreeModel
 * @see NavigatorComboBoxModel
 */
public interface DisplayProvider {
    /**
     * If an action returned from <code>getActions()</code> returns Boolean.TRUE
     * from <code>Action.getValue(PRECEDE_WITH_SEPARATOR)</code>, it will be 
     * shown in menus with a separator prepended.
     */
    public static final String PRECEDE_WITH_SEPARATOR = "precedeWithSeparator"; //NOI18N

    /**
     * Get a character iterator which can specify relative importance of different segments of text, so that if the
     * available display space is small, only that which is most important can be shown.
     *
     * @return A non-null WeightedCharacterIterator
     * @see WeightedString
     */
    public WeightedString getName (Object o);

    /**
     * Get a tooltip for this object.
     */
    public String getTooltip (Object o);

    /**
     * Get an icon for a given object.  May return null.
     */
    public Icon getIcon (Object o);

    /**
     * Get the list of actions that should appear in this object's popup menu. May return null.
     * @param o Given object, selected content. May be null, which means no context is selected.
     */
    public Action[] getActions (Object o);

    /**
     * Get the default action for this object - the one which should be invoked if the item is clicked or enter is
     * pressed on it in a tree or list.  This action should <i>not</i> be included in the array returned by
     * <code>getActions()</code>.
     * <p/>
     * May return null.
     *
     * @param o Given object, selected content. May be null, which means no context is selected.
     */
    public Action getDefaultAction (Object o);

    /**
     * Determine if the default action should be invoked on the first click; this is intentionally not specific to
     * objects in the model, but global for the model itself, since mixed behavior of objects in a single tree or list
     * would be confusing.
     */
    public boolean isDefaultActionInstant ();
}
