/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.navigation.jmi;

import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.modules.java.*;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MethodImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.UsageFinder;
import org.openide.*;
import org.openide.nodes.*;

import javax.swing.*;
import java.util.*;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.java.navigation.*;
import org.openide.cookies.EditorCookie;

/**
 * Contains usages of things the official APIs don't support that are done in unsavory ways.
 *
 * @author Tim Boudreau
 */
public final class Hacks {

    /**
     * Given a node , find the corresponding Element.
     *
     * @see ClassMemberRelatedItemProvider
     */
    public static Element getElementForNode (Node n) {
        assert !SwingUtilities.isEventDispatchThread () :
                "Dont call this on the AWT thread ever"; //NOI18N
            Element el = (Element)n.getLookup().lookup(Element.class);
            return el;
    }

    /**
     * Given an element representing some part of a method body or such, find the nearest enclosing ClassMember, or at
     * least try to.
     */
    private static Object findClassMember (Object o) {
        int ct = 0;
        //Limit it so we don't send this thread into an endless loop
        while ( notAClassMember ( o ) && ct < 10 ) {
            o = findOuter ( o );
            if (o == null) {
                break;
            }
            ct++;
        }
        return o;
    }

    private static Object findOuter (Object o) {
        while (!(o instanceof ClassMember) && o != null) {
          o = ((RefObject) o).refImmediateComposite();
        }
        return o;
    }

    private static boolean notAClassMember (Object o) {
        return !( o instanceof ClassMember );
    }

    public static Collection findUsagesOfElement (JavaDataObject dob, NamedElement el, ClassMemberRelatedItemProvider p) {
        Document d = documentFor (dob);
        String str = el.getName();
        if (d == null || str == null) {
            return Collections.EMPTY_LIST;
        }
        Resource resource = JavaModel.getResource ( dob.getPrimaryFile () );
        int startOff = el.getStartOffset();
        int endOff = el.getEndOffset();
        try {
            String all = d.getText(0, d.getLength());
            int pos = 0;
            List l = new ArrayList();
            while (pos >= 0) {
                int loc = all.indexOf(str, pos);
                if (loc == -1) {
                    break;
                }
//                System.err.println("Match at " + loc + " line " + d.getDefaultRootElement().getElementIndex(loc));
                l.add (new Integer(loc + str.length()-1));
                pos = loc + str.length();
            }
            if (l.isEmpty()) {
                return l;
            }
            HashSet set = new HashSet();
            for (Iterator it=l.iterator(); it.hasNext();) {
                int offset = ((Integer) it.next()).intValue();
                if (!p.active()) {
                    return Collections.EMPTY_SET;
                }
                if (offset < startOff || offset > endOff) {
                    Element curr = resource.getElementByOffset(offset);
                    
                    //XXX
                    String s;
                    try {
                        s = all.substring (curr.getStartOffset(), curr.getEndOffset());
                    } catch (StringIndexOutOfBoundsException se) {
                        //Bad offsets from javamodel sometimes
                        break;
                    }
//                    
//                    int ixx = all.indexOf (s);
//                    if (ixx != offset && s.indexOf (el.getName()) != -1) {
//                        int line = d.getDefaultRootElement().getElementIndex(offset);
//                        System.err.println("OFFSET MISMATCH: actual " + offset + " reported " + ixx + " diff " + (ixx - offset) + " actual line " + line + ": " + el2s(curr, all));
//                    }
                    
                    //XXX THIS MAKES NO SENSE:  sometimes getElementAt (23).getStartOffset() == 55 and things
                    //like this - the element returned by getElementBy
                    
                    if (!(curr instanceof ClassDefinition)) {

                        if (curr != null && match (curr, el, all)) {
                            set.add (curr);
                        }
                    }
                }
            }
            //XXX first need to match-check
            return extractClassMembers ( set, p);
            
        } catch (BadLocationException e) {
            ErrorManager.getDefault().notify (ErrorManager.INFORMATIONAL, e);
            return Collections.EMPTY_LIST;
        }
    }
    
    private static boolean match (final Element test, final NamedElement referenced, final String txt) {
        if (true) {
            return true;
        }
        if (referenced instanceof Field) {
            Field f = (Field) referenced;
            if (test instanceof VariableAccess) {
                VariableAccess va = (VariableAccess) test;
                Element el = va.getElement();
                if (f.equals(el)) {
                    return true;
                }
            }
        } else if (referenced instanceof Method) {
            Method m = (Method) referenced;
            if (test instanceof MethodInvocation) {
                MethodInvocation mi = (MethodInvocation) test;
                if (m.equals(mi.getElement())) {
                    return true;
                }
            }
        } 
//        if (test instanceof StatementBlock) {
//            StatementBlock sb = (StatementBlock) test;
//            System.err.println("STATEMENT BLOCK: ");
//            for (Iterator i=sb.getStatements().iterator(); i.hasNext();) {
//                Statement sta = (Statement) i.next();
//                System.err.println(" - STATEMENT CLASS " + sta.getClass().getName());
//                if (sta instanceof Assignment) {
//                    Assignment ag = (Assignment) sta;
//                    PrimaryExpression left = ag.getLeftSide();
//                    Expression right = ag.getRightSide();
//                    for (Iterator it2=left.getChildren().iterator(); it2.hasNext();) {
//                        Object o = it2.next();
//                        System.err.println("  LEFT CHILD " + o);
//                    }
//                    for (Iterator it2=right.getChildren().iterator(); it2.hasNext();) {
//                        Object o = it2.next();
//                        System.err.println("  RIGHT CHILD " + o);
//                    }
//                    
//                   
//                }
//            }
//        }
//        if (!(test instanceof ClassDefinition)) {
//            System.err.println("FAILED ON " + referenced.getName());
//            System.err.println("Could not match element type " + el2s(test, txt)); //XXX debug
//        }
        
        return true;
    }
    
    private static String el2s (Element el, String all) {
        StringBuffer sb = new StringBuffer ("\nCOULD NOT MATCH ");
        sb.append (el.getClass().getName());
        sb.append (" len " + (el.getEndOffset() -  el.getStartOffset()));
//        int ix = all.indexOf("\n", el.getStartOffset());
//        int end = Math.min(ix, el.getEndOffset());
//        if (end - el.getStartOffset() > 100) {
//            end = el.getStartOffset() + 100;
//        }
        int end = el.getEndOffset();
        sb.append (" CONTENT: '");
        sb.append (all.substring(el.getStartOffset(), end));
        sb.append ("'");
        return sb.toString();
    }
    
    private static Document documentFor (JavaDataObject dob) {
        EditorCookie ck = (EditorCookie) dob.getCookie(EditorCookie.class);
        return ck.getDocument();
    }
    
    /**
     * Finds all the usages of a NamedElement within a give class.  Uses NameFinder, which is not intended to be public
     * API.
     */
/*    public static Collection xx_findUsagesOfElement (JavaDataObject dob, NamedElement el,
                                                  ClassMemberRelatedItemProvider p) {
        //This method should work, used to work, but now UsagesFinder always returns
        //an empty collection. No idea why;  method above may be faster anyway
        
        UsageFinder finder;
        if (el instanceof CallableFeature) {
            CallableFeature cf = (CallableFeature) el;
            finder = new UsageFinder (cf, true, false, true);
        } else {
            finder = new UsageFinder ( el );
        }
        Resource resource = JavaModel.getResource ( dob.getPrimaryFile () );

        try {
            Collection c = finder.getUsers ( new Resource[]{resource} );
            c = new HashSet(c);
            if ( p.active () ) {
                try {
                    return ( extractClassMembers ( c, p ) );
                } catch ( NullPointerException npe ) {
                    //Diagnostics - UsagesFinder is throwing NPEs but I don't
                    //think my code is wrong
                    NullPointerException npe2 = new NullPointerException ( "NPE from Usage Finder looking for usages of " +
                            el + " on " + dob.getPrimaryFile ().getName () + " for" +
                            " " + p );
                    ErrorManager.getDefault ().annotate ( npe2, npe );
                    throw npe2;
                }
            } else {
                return Collections.EMPTY_SET;
            }
        } catch ( Exception e ) {
            ErrorManager.getDefault ().notify ( ErrorManager.INFORMATIONAL, e );
            return Collections.EMPTY_SET;
        }
    }
 */

    /**
     * UsageFinder will return granular elements like Statement, etc.  So we take each one, find the containing
     * ClassMember and return a collection of those.
     */
    private static Collection extractClassMembers (Collection invocations, ClassMemberRelatedItemProvider p) {
        if ( invocations.isEmpty () ) {
            return Collections.EMPTY_LIST;
        }
        Collection result = new HashSet ();
        for ( Iterator i = invocations.iterator (); i.hasNext (); ) {
            Object o = findClassMember ( i.next () );

            //All of this is expensive and we do not want to kill performance!
            Thread.currentThread ().yield ();

            if ( !p.active () ) {
                return Collections.EMPTY_SET;
            }
            if (o != null) {
                result.add ( o );
            }
        }
        return result;
    }

    /**
     * Find out if a method is overridden.  Relies on MethodImpl.getOverriddenMethods.  This seems to be horribly
     * expensive, so using an inherently unreliable hashCode cache.
     */
    public static boolean isOverride (Method m) {
        if ( fastOverrideCheck ( m ) ) {
            return true;
        }

        //This totally can't work reliably
        if ( overrides.contains ( new Integer ( m.hashCode () ) ) ) {
            return true;
        } else if ( overrides.contains ( new Integer ( -1 * m.hashCode () ) ) ) {
            return false;
        }

        if ( JUtils.overridesMethod ( m.getDeclaringClass ().getSuperClass (), m ) ) {
            return true;
        }

        Collection c = JavaModelUtil.getOverriddenMethods (m);
        boolean result = c != null && !c.isEmpty ();
        if ( result ) {
            overrides.add ( new Integer ( m.hashCode () ) );
        } else {
            overrides.add ( new Integer ( -1 * m.hashCode () ) );
        }
        return result;
    }
    
    private static boolean fastOverrideCheck (Method m) {
        if ("java.lang.Object".equals(m.getDeclaringClass())) {
            return false;
        }
        List l = m.getParameters ();
        if ( "hashCode".equals ( m.getName () ) && l.size () == 0 ) { //NOI18N
            return true;
        } else if ( "toString".equals ( m.getName () ) && l.size () == 0 ) { //NOI18N
            return true;
        } else if ( "clone".equals ( m.getName () ) && l.size () == 0 ) { //NOI18N
            return true;
        } else {
            return false;
        }
    }

    private static final HashSet overrides = new HashSet ();

    /**
     * Gets a Resource object for a JavaDataObject using JavaMetamodel.
     */
    public static Resource getResourceForDataObject (JavaDataObject dob) {
        return dob.isValid () ?
                JavaModel.getResource ( dob.getPrimaryFile () ) :
                null;
    }

}
