
/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * NavigatorJTree.java
 *
 * Created on September 25, 2004, 10:52 PM
 */

package org.netbeans.modules.java.navigation.base;

import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.java.navigation.spi.AbstractModel;
import org.netbeans.modules.java.navigation.spi.DisplayProvider;
import org.netbeans.modules.java.navigation.spi.NavigatorListModel;
import org.netbeans.modules.java.navigation.spi.NavigatorTreeModel;
import org.openide.util.NbBundle;

/**
 *
 * @author Tim Boudreau
 */
public class NavigatorJTree extends JTree {
    JLabel widthTestLabel = NavigatorJList.widthTestLabel;
    
    /** holds reference to component which visually encloses this list */
    private JComponent enclosingComp; 
    
    /** Creates a new instance of NavigatorJTree */
    public NavigatorJTree(JComponent enclosingComp) {
        this.enclosingComp = enclosingComp;
        getAccessibleContext().setAccessibleName(
                NbBundle.getMessage(NavigatorJTree.class, "ACC_NavTreeName") //NOI18N
                );
        getAccessibleContext().setAccessibleDescription(
                NbBundle.getMessage(NavigatorJTree.class, "ACC_NavTreeDesc") //NOI18N
                );
        
///        setLargeModel(true);
    }
    /*
    private static class UI extends BasicTreeUI {
        protected AbstractLayoutCache createLayoutCache() {
            AbstractLayoutCache result = new NullLayoutCache ((TreeModelSupport2) tree.getModel());
            result.setRowHeight(Math.min(16, tree.getRowHeight()));
            return result;
        }
    }
     */
    /*
    public void setModel (TreeModel mdl) {
        super.setModel(mdl);
        int rowHeight = getRowHeight();
        if (mdl instanceof TreeModelSupport2) {
            if (!(getUI() instanceof UI)) {
                setUI (new UI());
            }
        } else if (getUI() instanceof UI) {
            super.updateUI();
        }
        setRowHeight(rowHeight);
    }
     */
    
    public void addNotify () {
        super.addNotify ();
        ToolTipManager.sharedInstance ().registerComponent ( this );
    }
    
    private int approximateWidth (String s) {
        widthTestLabel.setText ( s );
        return widthTestLabel.getPreferredSize ().width;
    }

    public void removeNotify () {
        super.removeNotify ();
        ToolTipManager.sharedInstance ().unregisterComponent ( this );
    }

    /** Always select some element when focused */
    public boolean requestFocusInWindow () {
        boolean result = super.requestFocusInWindow();
        if (getSelectionPath() == null && getModel().getRoot() != null) {
            setSelectionRow(0);
        }
        return result;
    }
    
    public String getToolTipText (MouseEvent me) {
        if ( getModel () instanceof NavigatorTreeModel ) {
            NavigatorTreeModel nlm = (NavigatorTreeModel) getModel ();
            Point p = me.getPoint();
            TreePath path = getPathForLocation (p.x, p.y);
            
            if ( path != null ) {
                Object rep = path.getLastPathComponent();
                
                if ( AbstractModel.isWaitMarker( rep ) || AbstractModel.isInvalidMarker ( rep ) ) {
                    return null;
                }
                String result = nlm.getTooltip ( rep );
                if (result != null) {
                    return result;
                }
            }
        }
        return "";
    }    
    
    public Point getToolTipLocation (MouseEvent e) {
        Point result = e.getPoint ();
        Container c = getTopLevelAncestor ();
        Rectangle r = enclosingComp.getBounds ();
        Rectangle converted = SwingUtilities.convertRectangle ( this, r, c );
        boolean closerToLeft = converted.x + converted.width < c.getWidth () - converted.x;

        result = SwingUtilities.convertPoint ( this, result, enclosingComp );

        int approxWidth = approximateWidth ( getToolTipText ( e ) );
        int approxHeight = widthTestLabel.getPreferredSize ().height;
        if ( closerToLeft ) {
            result.x = r.x + r.width + 5;
        } else {
            result.x = r.x - ( approxWidth + 10 );
        }

        result = SwingUtilities.convertPoint ( enclosingComp, result, this );

        Point orig = e.getPoint ();
        
        TreePath path = getPathForLocation(orig.x, orig.y);
        if (path != null) {
            Rectangle r2 = getPathBounds(path);
            result.y = r2.y;
        }

        return result;
    }
    
    /** Hack to get tooltips working on Ctrl+F1. Always returns empty string,
     * but invokes tooltip by a hack on selected item.
     */
    public String getToolTipText() {
        TreePath selPath = getSelectionPath();
        if (selPath != null) {
            final Rectangle rect = getPathBounds(selPath);
            if (rect != null) {
                SwingUtilities.invokeLater(new Runnable () {
                    public void run () {
                        TooltipHack.invokeTip(NavigatorJTree.this,
                                (int)rect.getCenterX(), (int)rect.getCenterY(),
                                Integer.MAX_VALUE);
                    }
                });
            }
        }
            
        return "";
    }
    

}
