/*
* The contents of this file are subject to the terms of the Common Development
* and Distribution License (the License). You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the License at http://www.netbeans.org/cddl.html
* or http://www.netbeans.org/cddl.txt.
* 
* When distributing Covered Code, include this CDDL Header Notice in each file
* and include the License file at http://www.netbeans.org/cddl.txt.
* If applicable, add the following below the CDDL Header, with the fields
* enclosed by brackets [] replaced by your own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* The Original Software is NetBeans. The Initial Developer of the Original
* Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
* Microsystems, Inc. All Rights Reserved.
*/
/*
 * OverrideAction.java
 *
 * Created on September 19, 2004, 4:01 AM
 */

package org.netbeans.modules.java.navigation.actions;

import org.netbeans.jmi.javamodel.*;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.JavaEditor;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.*;
import org.openide.cookies.*;
import org.openide.util.*;
import org.openide.windows.*;

import javax.swing.*;
import javax.swing.text.*;
import javax.swing.text.Element;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.util.List;
import org.netbeans.modules.java.navigation.jmi.JUtils;

/**
 * A little hacky, but works.  Probably a better way to handle adding imports than manually parsing the import section
 * from the editor, but I couldn't find one.  Generates imports, and goes out of its way to generate good variable names
 * if the class source is not available.
 *
 * @author Tim Boudreau
 */
public final class OverrideAction extends AbstractAction {
    private final Method m;
    private final JavaClass target;
    private final JavaDataObject jdo;

    public OverrideAction (Method m, JavaClass target, JavaDataObject jdo) {
        this.m = m;
        this.target = target;
        this.jdo = jdo;
        putValue ( Action.NAME, NbBundle.getMessage ( OverrideAction.class,
                isInterfaceMethod () ? "LBL_implement" : "LBL_override" ) ); //NOI18N
    }

    private boolean isInterfaceMethod () {
        ClassDefinition jc=m.getDeclaringClass();
        
        if (jc instanceof JavaClass) {
            return ((JavaClass)jc).isInterface ();
        }
        return false;
    }

    public void actionPerformed (ActionEvent ae) {
        Set toImport = new HashSet ();
        String nue = create ( toImport );
        JavaEditor ed = jdo.getJavaEditor ();
        if ( ed == null ) {
            OpenCookie oc = (OpenCookie) jdo.getCookie ( OpenCookie.class );
            if ( oc == null ) {
                Toolkit.getDefaultToolkit ().beep ();
                return;
            } else {
                oc.open ();
            }
        }

        JEditorPane[] panes = ed != null ? ed.getOpenedPanes () : null;
        JEditorPane pane = panes != null && panes.length >= 0 ? ed.getOpenedPanes ()[ 0 ] : null;
        BoundedRangeModel scModel = null;
        if ( pane != null && !toImport.isEmpty () ) {
            JScrollPane jsp = (JScrollPane) SwingUtilities.getAncestorOfClass ( JScrollPane.class, pane );
            if ( jsp != null ) {
                scModel = jsp.getHorizontalScrollBar ().getModel ();
                scModel.setValueIsAdjusting ( true );
            }
            pane.setIgnoreRepaint ( true );
        }
        int curpos = 0;

        try {
            StyledDocument doc = ed.getDocument ();
            int pos = getInsertPosition ( doc );
            try {
                doc.insertString ( pos - 1, nue, null );
            } catch ( Exception e ) {
                ErrorManager.getDefault ().notify ( e );
            }

            int importsLength = 0;
            if ( !toImport.isEmpty () ) {
                importsLength = createImports ( toImport, doc );
                if ( scModel != null ) {
                    scModel.setValueIsAdjusting ( false );
                }
            }

            curpos = importsLength + pos + nue.indexOf ( "{" ) + 8;
        } finally {
            if ( pane != null ) {
                pane.getCaret ().setDot ( curpos );
                TopComponent tc = (TopComponent)
                        SwingUtilities.getAncestorOfClass ( TopComponent.class, pane );
                if ( tc != null ) {
                    tc.requestActive ();
                }
                pane.setIgnoreRepaint ( false );
            }
        }
    }

    private static int getInsertPosition (Document doc) {
        //XXX broken for inner classes
        Element el = doc.getDefaultRootElement ();
        try {
            String s = doc.getText ( 0, doc.getLength () );
            if ( s.indexOf ( "}" ) >= 0 ) { //NOI18N
                return el.getStartOffset () + s.lastIndexOf ( "}" ); //NOI18N
            }
        } catch ( BadLocationException e ) {
            //do nothing
        }
        return doc.getLength () - 2;
    }

    private String create (Set toImport) {
        StringBuffer sb = new StringBuffer ( "\n\n" );

        int mods = m.getModifiers ();
        sb.append ( "    " );

        if ( ( mods & java.lang.reflect.Modifier.PUBLIC ) != 0 || ( (JavaClass) m.getDeclaringClass () ).isInterface () ) {
            sb.append ( "public " );
        }
        if ( ( mods & java.lang.reflect.Modifier.PROTECTED ) != 0 ) {
            sb.append ( "protected " );
        }
        if ( ( mods & java.lang.reflect.Modifier.STATIC ) != 0 ) {
            sb.append ( "static" );
        }
        if ( m.getType () != null ) {
            sb.append ( maybeStripPackage ( m.getType (), toImport ) );
            sb.append ( ' ' );
        } else {
            sb.append ( "void " );
        }
        sb.append ( m.getName () );
        sb.append ( '(' );
        List params = m.getParameters ();
        if ( !params.isEmpty () ) {
            HashSet varNames = new HashSet ();
            for ( Iterator i = params.iterator (); i.hasNext (); ) {
                Parameter p = (Parameter) i.next ();

                String name = p.getName ();
                if ( name == null || name.trim ().length () == 0 ) {
                    name = JUtils.generateBelievableParameterName ( p, varNames );
                }
                sb.append ( maybeStripPackage ( p.getType (), toImport ) );
                sb.append ( ' ' );
                sb.append ( name );
                if ( i.hasNext () ) {
                    sb.append ( ", " );
                }
            }
        }
        sb.append ( ')' );
        List es = m.getExceptions ();
        if ( !es.isEmpty () ) {
            sb.append ( " throws " );
            for ( Iterator i = es.iterator (); i.hasNext (); ) {
                ParameterizedType exc = (ParameterizedType) i.next ();

                sb.append ( maybeStripPackage ( exc, toImport ) );
                if ( i.hasNext () ) {
                    sb.append ( ", " );
                }
            }
        }
        sb.append ( " {\n        \n    }" ); //NOI18N
        return sb.toString ();
    }

    private int createImports (Set imps, Document d) {
        int result = 0;
        for ( Iterator i = imps.iterator (); i.hasNext (); ) {
            Type t = (Type) i.next ();
            int pos = findImportInsertLocation ( d, t );
            StringBuffer sb = new StringBuffer ();
            sb.append ( "import " );
            String tname = t.getName ();
            int bkt = tname.indexOf ( "[" );
            if ( bkt > 0 ) {
                tname = tname.substring ( 0, bkt );
            }
            sb.append ( tname );
            sb.append ( ";\n" );
            result += sb.length ();
            try {
                d.insertString ( pos, sb.toString (), null );
            } catch ( Exception e ) {
                ErrorManager.getDefault ().notify ( e );
                return 0;
            }
        }
        return result;
    }

    private int first = -1;
    private int last = -1;

    private int findImportInsertLocation (Document d, Type t) {
        //Horrible...
        try {
            Set imps = new HashSet ();
            int pkgLoc = 0;
            int ct = d.getDefaultRootElement ().getElementCount ();
            int ix = 0;
            for ( int i = 0; i < ct; i++ ) {
                Element e = d.getDefaultRootElement ().getElement ( i );
                String s = d.getText ( e.getStartOffset (), e.getEndOffset () - e.getStartOffset () );
                if ( s.trim ().startsWith ( "import" ) ) { //NOI18N
                    imps.add ( new ImpInfo ( s, ix, e ) );
                    last = i;
                    if ( first == -1 ) {
                        first = i;
                    }
                }
                if ( s.trim ().startsWith ( "package" ) ) { //NOI18N
                    pkgLoc = e.getEndOffset ();
                }
                ix += 2;
                if ( i - last > 10 && first != -1 ) {
                    break;
                }
            }
            if ( imps.isEmpty () ) {
                imps = null;
                return last != -1 ? d.getDefaultRootElement ().getElement ( last ).getEndOffset () : pkgLoc;
            } else {
                ImpInfo toAdd = new ImpInfo ( "import " + t.getName () + ";\n", 0, null );
                imps.add ( toAdd );

                ImpInfo[] sorted = (ImpInfo[]) imps.toArray ( new ImpInfo[ 0 ] );
                Arrays.sort ( sorted );

                int idx = Arrays.asList ( sorted ).indexOf ( toAdd );
                if ( idx > 0 ) {
                    toAdd.idx = sorted[ idx - 1 ].idx + 1;
                    toAdd.element = sorted[ idx - 1 ].element;
                }

                sortByIndex = true;
                Arrays.sort ( sorted );
                sortByIndex = false;

                if ( toAdd.element == null ) {
                    return pkgLoc;
                } else {
                    int result = toAdd.element.getEndOffset ();
                    return result;
                }
            }
        } catch ( Exception e ) {
            ErrorManager.getDefault ().notify ( e );
        }
        return 0;
    }

    private boolean sortByIndex = false;

    private final class ImpInfo implements Comparable {
        int idx;
        final String s;
        Element element;

        public ImpInfo (String s, int idx, Element e) {
            this.s = s;
            this.idx = idx;
            this.element = e;
        }

        public int compareTo (Object o) {
            return sortByIndex ? idx - ( (ImpInfo) o ).idx : toString ().compareTo ( o.toString () );
        }

        public String toString () {
            return s;
        }
    }

    private String maybeStripPackage (Type type, Set imps) {
        if ( !isImported ( type ) ) {
            imps.add ( type );
        }
        String typeName = type.getName ();
        int idx = typeName.lastIndexOf ( "." );
        if ( idx != -1 ) {
            typeName = typeName.substring ( idx + 1 );
        }

        return typeName;
    }

    private boolean isImported (Type type) {
        String typeName = type.getName ();
        if ( typeName.indexOf ( "java.lang." ) == 0 && typeName.lastIndexOf ( "." ) == 9 ) {
            return true;
        }
        if ( JUtils.isPrimitiveTypeName ( typeName ) ) {
            return true;
        }

        Resource r = JavaModel.getResource ( jdo.getPrimaryFile () );
        List imps = r.getImports ();
        String pkgpart = typeName;
        if ( pkgpart.indexOf ( "." ) != -1 ) {
            int idx = pkgpart.lastIndexOf ( "." );
            pkgpart = pkgpart.substring ( 0, idx );
        }
        for ( Iterator i = imps.iterator (); i.hasNext (); ) {
            Import imp = (Import) i.next ();
            String imported = imp.getImportedNamespace ().getName ();
            if ( imported.equals ( typeName ) ) {
                return true;
            }
            if ( typeName.startsWith ( pkgpart ) && typeName.lastIndexOf ( "." ) == pkgpart.length () && imported.equals (
                    pkgpart ) ) {
                return true;
            }
        }
        return false;
    }

    public boolean isEnabled () {
        return target.isValid () &&
                ( ( m.getModifiers () & java.lang.reflect.Modifier.FINAL ) == 0 && !isSerializationMethod () ) &&
                ( ( m.getModifiers () & java.lang.reflect.Modifier.PRIVATE ) == 0 && !isSerializationMethod () ) &&
                jdo.getCookie ( OpenCookie.class ) != null &&
                jdo.getPrimaryFile ().canWrite () &&
                !JUtils.overridesMethod ( target, m ) && !originIsTarget ();
    }

    private boolean originIsTarget () {
        return m.getDeclaringClass () == target;
    }

    private boolean isSerializationMethod () {
        return "readObject".equals ( m.getName () ) || "writeObject".equals ( m.getName () ) ||
                "readExternal".equals ( m.getName () ) || "writeExternal".equals ( m.getName () );
    }
}
