/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.navigation;

import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;


/**
 * Navigator panel impl for java sources, which shows inheritance tree. 
 *
 * @author Dafe Simonek
 */
public final class InheritanceTreePanel implements NavigatorPanel, LookupListener {
    
    /** UI of this navigator panel */ 
    private InheritanceTreePanelUI panelUI;
    /** model actually containing content of this panel */ 
    private InheritanceTreeModel curModel;
    /** current context to work on */
    private Lookup.Result curContext;
    /** actual data */
    private JavaDataObject curData;

    public String getDisplayName () {
        return NbBundle.getBundle(InheritanceTreePanel.class).getString("LBL_inheritance"); //NOI18N
    }
    
    public String getDisplayHint () {
        // XXX - TBD
        return null;
    }
    
    public JComponent getComponent () {
        return getPanelUI();
    }
    
    /** Creates and activates InheritanceTreeModel model for given context.
     */
    public void panelActivated (Lookup context) {
        curContext = context.lookup(ClassMemberPanel.JDOS);
        curContext.addLookupListener(this);
        curData = (JavaDataObject)(((List)curContext.allInstances()).get(0));
        setNewContent(curData);
    }
    
    /** Deactivates inheritance tree model.
     */
    public void panelDeactivated () {
        curContext.removeLookupListener(this);
        curContext = null;
        curModel.removeNotify();
        curModel = null;
        curData = null;
    }

    /** Impl of LookupListener, reacts to changes of context */
    public void resultChanged (LookupEvent ev) {
        Collection data = ((Lookup.Result)ev.getSource()).allInstances();
        if (!data.isEmpty()) {
            JavaDataObject jdo = (JavaDataObject)data.iterator().next();
            if (!jdo.equals(curData)) {
                curModel.removeNotify();
                curData = jdo;
                setNewContent(jdo);
            }
        }
    }
    
    /** Default activated Node strategy is enough for now */
    public Lookup getLookup () {
        return null;
    }
    
    /************ non public stuff **********/
    
    private void setNewContent (JavaDataObject jdo) {
        curModel = new InheritanceTreeModel(jdo);
        getPanelUI().getContent().setModel(curModel);
        curModel.addNotify();
    }
    
    /** Accessor for instance handling UI */
    private InheritanceTreePanelUI getPanelUI () {
        if (panelUI == null) {
            panelUI = new InheritanceTreePanelUI();
        }
        return panelUI;
    }


}
