/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * InheritanceTreeModel.java
 *
 * Created on September 19, 2004, 12:05 AM
 */

package org.netbeans.modules.java.navigation;

import javax.swing.JComponent;
import org.netbeans.api.mdr.events.*;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.loaders.*;

import javax.swing.*;
import java.util.*;
import org.netbeans.modules.java.navigation.actions.OpenAction;
import org.netbeans.modules.java.navigation.actions.OverrideAction;
import org.netbeans.modules.java.navigation.jmi.JUtils;
import org.netbeans.modules.java.navigation.spi.strings.WeightedString;
import org.netbeans.modules.java.navigation.spi.TreeModelSupport;
import org.netbeans.modules.java.navigation.spi.AbstractModel;


/**
 * A tree which shows the superclasses and interfaces of the selected class, and can be expanded to show the class
 * members.
 *
 * @author Tim Boudreau
 */
final class InheritanceTreeModel extends TreeModelSupport implements MDRChangeListener {
    private JavaClass clazz = null;
    private final Set listeningTo = new HashSet ();

    public InheritanceTreeModel (JavaDataObject dob) {
        super ( dob );
    }

    /** No filters */
    public JComponent getFilters () {
        return null;
    }

    private JavaDataObject getJDO () {
        return (JavaDataObject) getRoot ();
    }

    protected WeightedString assembleName (WeightedString str, Object o) {
        if (o instanceof ClassMemberModel.ItemPaintingData) {
            return ((ClassMemberModel.ItemPaintingData)o).getWString();
        }
        JUtils.extractName ( str, getJMIData(o), clazz, false );
        return str;
    }

    public Action[] getActions (Object o) {
        return null;
    }

    public Action getDefaultAction (Object o) {
        return OpenAction.createOpenAction(getJMIData(o));
    }

    public Icon getIcon (Object o) {
        return JUtils.iconFor(getJMIData(o));
    }

    public String getTooltip (Object o) {
        return JUtils.getTooltip(getJMIData(o), clazz);
    }

    public boolean isShowRoot () {
        return true;
    }

    /** XXX - need to get this working! */
    public List getSearchResults (String partial) {
        return Collections.EMPTY_LIST;

        // XXX [dafe] - commented out, not working at all - here objects are
        // returned in a list, but SearchPanel expects TreePaths
        
/*        if ( getList () == null ) {
            return Collections.EMPTY_LIST;
        }
        ArrayList results = new ArrayList ();
        StringFilter sf = StringFilter.create ( partial );

        if ( sf.match ( getJDO ().getName () ) ) {
            results.add ( getJDO () );
        }
        for ( Iterator i = getList ().iterator (); i.hasNext (); ) {
            Object o = i.next ();
            ClassMemberModel mdl = (ClassMemberModel) modelForRootObject ( o, false );
            if ( mdl != null ) {
                results.addAll ( mdl.getSearchResults ( partial ) );
            }
        }
        return results;
 */
    }

    protected static boolean isObjectValid (Object o) {
        if ( o instanceof Element ) {
            Element m = (Element) o;
            return m.isValid ();
        } else if ( o instanceof DataObject ) {
            DataObject dob = (DataObject) o;
            return dob.isValid ();
        } else {
            return true;
        }
    }

    protected void stopListening () {
        if ( !listeningTo.isEmpty () ) {
            for ( Iterator i = listeningTo.iterator (); i.hasNext (); ) {
                ( (MDRChangeSource) i.next () ).removeListener ( this );
            }
            listeningTo.clear ();
        }
    }

    public void change (MDRChangeEvent e) {
        if (e instanceof AttributeEvent) {
            change();
        }
    }

    protected AbstractModel createModelFor (Object o) {
        ClassMemberModel result = new ClassMemberModel ( (JavaClass) o );
        result.setIncludeInners(false);
        result.setDataObject ( getJDO () );
        return result;
    }
    
    /** for tests to test loadContents */
    List testLoadContents () {
        return loadContents();
    }

    protected List loadContents () {
//        System.err.println("InheritanceTreeModel.loadContents");
        ((JMManager) JMManager.getManager()).waitScanFinished();
        Resource r = JavaModel.getResource ( getJDO ().getPrimaryFile () );
        List result = null;
        if ( r != null ) {
            JavaModel.setClassPath(r);
            Stack classes = new Stack ();
            for ( Iterator i = r.getClassifiers ().iterator (); i.hasNext (); ) {
                clazz = (JavaClass) i.next ();
                gatherSupersAndInterfaces ( clazz, classes);
            }
            result = new ArrayList ( classes );
        }
        if ( r instanceof MDRChangeSource ) {
            listeningTo.add ( r );
            ( (MDRChangeSource) r ).addListener ( this );
        }
        return result;
    }

    private void gatherSupersAndInterfaces (ClassDefinition clazz, Stack stack) {
        ClassDefinition curr = null;
        ClassDefinition source = null;
        for ( Iterator i = clazz.getInterfaces ().iterator (); i.hasNext (); ) {
            curr = (ClassDefinition)i.next ();
            // use source if possible
            source = JUtils.getSourceForBinary((ClassDefinition)curr);
            if (source != null) {
                curr = source;
            }
            // add to stack
            if ( !stack.contains ( curr ) ) {
                stack.push ( curr );
            }
        }
        ClassDefinition zuper = clazz.getSuperClass ();
        // ignore interfaces that return java.lang.Object as their superclass
        // (possibly javacore bug?)
        if ((clazz instanceof JavaClass) && ((JavaClass)clazz).isInterface() &&
            "java.lang.Object".equals(zuper.getName())) {  // NOI18N
            return;
        }
        // try to get source and use it, binary as fallback
        if (zuper != null) {
            source = JUtils.getSourceForBinary(zuper);
            if (source != null) {
                zuper = source;
            }
        }
        
        if ( zuper != null && !stack.contains ( zuper ) ) {
            stack.push ( zuper );
            gatherSupersAndInterfaces ( zuper, stack );
        }
    }
    
    /** Extraxts JMI data from given object. JMIData may be encapsulated
     * inside ItemPaintingData class.
     */
    private Object getJMIData (Object obj) {
        if (obj instanceof ClassMemberModel.ItemPaintingData) {
            return ((ClassMemberModel.ItemPaintingData)obj).getJMIData();
        }
        return obj;
    }

    
}
