/*
* The contents of this file are subject to the terms of the Common Development
* and Distribution License (the License). You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the License at http://www.netbeans.org/cddl.html
* or http://www.netbeans.org/cddl.txt.
* 
* When distributing Covered Code, include this CDDL Header Notice in each file
* and include the License file at http://www.netbeans.org/cddl.txt.
* If applicable, add the following below the CDDL Header, with the fields
* enclosed by brackets [] replaced by your own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* The Original Software is NetBeans. The Initial Developer of the Original
* Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
* Microsystems, Inc. All Rights Reserved.
*/
/*
 * ClassMemberComparator.java
 *
 * Created on September 24, 2004, 12:24 AM
 */

package org.netbeans.modules.java.navigation;

import org.netbeans.jmi.javamodel.*;

import java.util.*;
import org.netbeans.jmi.javamodel.NamedElement;
import org.openide.ErrorManager;
import org.netbeans.modules.java.navigation.jmi.JUtils;

/**
 * Sorts ClassMembers as follows: <ul> <li>Alphabetically in groups of constructors, methods, fields in that order</li>
 * <li>Inner classes grouped subsequently, alphabetically by inner class name, with the same ordering for their
 * members</li>
 *
 * @author tim
 */
public final class ClassMemberComparator implements Comparator {
    // private static final String LOW_STRING = new String ( new char[]{(char) 50} );
    private final JavaClass clazz;

    /**
     * Creates a new instance of ClassMemberComparator
     */
    public ClassMemberComparator (JavaClass outer) {
        this.clazz = outer;
    }

    public int compare (Object a, Object b) {
        String name1 = null, name2 = null;
        // try to use getName if possible, it's faster then toString,
        // but can return null is some cases (constructors)
        if (a instanceof NamedElement) {
            name1 = ((NamedElement)a).getName();
        }
        if (b instanceof NamedElement) {
            name2 = ((NamedElement)b).getName();
        }
        if (name1 == null) {
            name1 = a.toString();
        }
        if (name2 == null) {
            name2 = b.toString();
        }
        
        int result = name1.compareTo ( name2 );
        int result2 = result;
        
        a = JUtils.unwrap ( a );
        b = JUtils.unwrap ( b );

        if ( a instanceof ClassMember && b instanceof ClassMember ) {
            ClassMember cma = (ClassMember) a;
            ClassMember cmb = (ClassMember) b;

            ClassDefinition cd1 = cma.getDeclaringClass ();
            ClassDefinition cd2 = cmb.getDeclaringClass ();

            if (cd1 == cd2) {
                // constructors, then methods, then fields
                if (cma.getClass().equals(cmb.getClass())) {
                    result2 = result;
                } else if (cma instanceof Field && !(cmb instanceof Field)) {
                    result2 = 1;
                } else if (!(cma instanceof Field) && cmb instanceof Field) {
                    result2 = -1;
                } else if (cma instanceof Constructor && !(cmb instanceof Constructor)) {
                    result2 = -1;
                } else {
                    result2 = 1;
                }
            } else if (clazz == cd1) {
                result2 = -1;
            } else if (clazz == cd2) {
                result2 = 1;
            } else {
                result2 = cd1.getName().compareTo(cd2.getName());
            }
        }
        
        return result2;
    }
    
}
