/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *  
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *   
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.jmi.javamodel;

/**
 * JavaModel package interface.
 * Entry point to the Java metadata. Contains getters for all element class 
 * element objects - i.e. factories (represented by <i>ElementName</i>Class 
 * interfaces). Represents a virtual Java metadata database containing all 
 * metadata for a given set of Java sources or class files (e.g. a classpath 
 * element).
 * <p/>
 * Here is a simple example of using JavaModelPackage to create a new instan
 * ce of a Resource (representing a file containing Java classes):
 * <p/>
 * <pre>
 * // obtain instance of JavaModelPackage
 * // e.g. by calling MDRepository.getExtent()
 * // or using some utility method that can be provided
 * // by an implementation of a Java repository
 * JavaModelPackage pkg = ...
 * // get reference to a factory for Resource meta-class
 * ResourceClass rscFactory = pkg.getResource();
 * // create a new instance of Resource
 * Resource rsc = rscFactory.createResource();
 * </pre>
 *  
 * <p><em><strong>Note:</strong> This type should not be subclassed or implemented 
 * by clients. It is generated from a MOF metamodel and automatically implemented 
 * by MDR (see <a href="http://mdr.netbeans.org/">mdr.netbeans.org</a>).</em></p>
 */
public interface JavaModelPackage extends javax.jmi.reflect.RefPackage {
    /**
     * Returns UnresolvedAnnotationType class proxy object.
     * @return UnresolvedAnnotationType class proxy object.
     */
    public org.netbeans.jmi.javamodel.UnresolvedAnnotationTypeClass getUnresolvedAnnotationType();
    /**
     * Returns ArgumentList class proxy object.
     * @return ArgumentList class proxy object.
     */
    public org.netbeans.jmi.javamodel.ArgumentListClass getArgumentList();
    /**
     * Returns TypeArgument class proxy object.
     * @return TypeArgument class proxy object.
     */
    public org.netbeans.jmi.javamodel.TypeArgumentClass getTypeArgument();
    /**
     * Returns Feature class proxy object.
     * @return Feature class proxy object.
     */
    public org.netbeans.jmi.javamodel.FeatureClass getFeature();
    /**
     * Returns ArrayReference class proxy object.
     * @return ArrayReference class proxy object.
     */
    public org.netbeans.jmi.javamodel.ArrayReferenceClass getArrayReference();
    /**
     * Returns FieldGroup class proxy object.
     * @return FieldGroup class proxy object.
     */
    public org.netbeans.jmi.javamodel.FieldGroupClass getFieldGroup();
    /**
     * Returns TypeReference class proxy object.
     * @return TypeReference class proxy object.
     */
    public org.netbeans.jmi.javamodel.TypeReferenceClass getTypeReference();
    /**
     * Returns ExpressionStatement class proxy object.
     * @return ExpressionStatement class proxy object.
     */
    public org.netbeans.jmi.javamodel.ExpressionStatementClass getExpressionStatement();
    /**
     * Returns NullLiteral class proxy object.
     * @return NullLiteral class proxy object.
     */
    public org.netbeans.jmi.javamodel.NullLiteralClass getNullLiteral();
    /**
     * Returns CharLiteral class proxy object.
     * @return CharLiteral class proxy object.
     */
    public org.netbeans.jmi.javamodel.CharLiteralClass getCharLiteral();
    /**
     * Returns DoubleLiteral class proxy object.
     * @return DoubleLiteral class proxy object.
     */
    public org.netbeans.jmi.javamodel.DoubleLiteralClass getDoubleLiteral();
    /**
     * Returns FloatLiteral class proxy object.
     * @return FloatLiteral class proxy object.
     */
    public org.netbeans.jmi.javamodel.FloatLiteralClass getFloatLiteral();
    /**
     * Returns BooleanLiteral class proxy object.
     * @return BooleanLiteral class proxy object.
     */
    public org.netbeans.jmi.javamodel.BooleanLiteralClass getBooleanLiteral();
    /**
     * Returns LongLiteral class proxy object.
     * @return LongLiteral class proxy object.
     */
    public org.netbeans.jmi.javamodel.LongLiteralClass getLongLiteral();
    /**
     * Returns IntLiteral class proxy object.
     * @return IntLiteral class proxy object.
     */
    public org.netbeans.jmi.javamodel.IntLiteralClass getIntLiteral();
    /**
     * Returns StringLiteral class proxy object.
     * @return StringLiteral class proxy object.
     */
    public org.netbeans.jmi.javamodel.StringLiteralClass getStringLiteral();
    /**
     * Returns LocalVarDeclaration class proxy object.
     * @return LocalVarDeclaration class proxy object.
     */
    public org.netbeans.jmi.javamodel.LocalVarDeclarationClass getLocalVarDeclaration();
    /**
     * Returns ConstructorInvocation class proxy object.
     * @return ConstructorInvocation class proxy object.
     */
    public org.netbeans.jmi.javamodel.ConstructorInvocationClass getConstructorInvocation();
    /**
     * Returns ArrayInitialization class proxy object.
     * @return ArrayInitialization class proxy object.
     */
    public org.netbeans.jmi.javamodel.ArrayInitializationClass getArrayInitialization();
    /**
     * Returns ForEachStatement class proxy object.
     * @return ForEachStatement class proxy object.
     */
    public org.netbeans.jmi.javamodel.ForEachStatementClass getForEachStatement();
    /**
     * Returns EnumConstant class proxy object.
     * @return EnumConstant class proxy object.
     */
    public org.netbeans.jmi.javamodel.EnumConstantClass getEnumConstant();
    /**
     * Returns JavaEnum class proxy object.
     * @return JavaEnum class proxy object.
     */
    public org.netbeans.jmi.javamodel.JavaEnumClass getJavaEnum();
    /**
     * Returns AnnotableElement class proxy object.
     * @return AnnotableElement class proxy object.
     */
    public org.netbeans.jmi.javamodel.AnnotableElementClass getAnnotableElement();
    /**
     * Returns Annotation class proxy object.
     * @return Annotation class proxy object.
     */
    public org.netbeans.jmi.javamodel.AnnotationClass getAnnotation();
    /**
     * Returns AttributeValue class proxy object.
     * @return AttributeValue class proxy object.
     */
    public org.netbeans.jmi.javamodel.AttributeValueClass getAttributeValue();
    /**
     * Returns Attribute class proxy object.
     * @return Attribute class proxy object.
     */
    public org.netbeans.jmi.javamodel.AttributeClass getAttribute();
    /**
     * Returns AnnotationType class proxy object.
     * @return AnnotationType class proxy object.
     */
    public org.netbeans.jmi.javamodel.AnnotationTypeClass getAnnotationType();
    /**
     * Returns UnresolvedClass class proxy object.
     * @return UnresolvedClass class proxy object.
     */
    public org.netbeans.jmi.javamodel.UnresolvedClassClass getUnresolvedClass();
    /**
     * Returns ElementReference class proxy object.
     * @return ElementReference class proxy object.
     */
    public org.netbeans.jmi.javamodel.ElementReferenceClass getElementReference();
    /**
     * Returns Invocation class proxy object.
     * @return Invocation class proxy object.
     */
    public org.netbeans.jmi.javamodel.InvocationClass getInvocation();
    /**
     * Returns ClassDefinition class proxy object.
     * @return ClassDefinition class proxy object.
     */
    public org.netbeans.jmi.javamodel.ClassDefinitionClass getClassDefinition();
    /**
     * Returns ComplexExpression class proxy object.
     * @return ComplexExpression class proxy object.
     */
    public org.netbeans.jmi.javamodel.ComplexExpressionClass getComplexExpression();
    /**
     * Returns ClassExpression class proxy object.
     * @return ClassExpression class proxy object.
     */
    public org.netbeans.jmi.javamodel.ClassExpressionClass getClassExpression();
    /**
     * Returns ThisExpression class proxy object.
     * @return ThisExpression class proxy object.
     */
    public org.netbeans.jmi.javamodel.ThisExpressionClass getThisExpression();
    /**
     * Returns Literal class proxy object.
     * @return Literal class proxy object.
     */
    public org.netbeans.jmi.javamodel.LiteralClass getLiteral();
    /**
     * Returns NewClassExpression class proxy object.
     * @return NewClassExpression class proxy object.
     */
    public org.netbeans.jmi.javamodel.NewClassExpressionClass getNewClassExpression();
    /**
     * Returns NewArrayExpression class proxy object.
     * @return NewArrayExpression class proxy object.
     */
    public org.netbeans.jmi.javamodel.NewArrayExpressionClass getNewArrayExpression();
    /**
     * Returns VariableAccess class proxy object.
     * @return VariableAccess class proxy object.
     */
    public org.netbeans.jmi.javamodel.VariableAccessClass getVariableAccess();
    /**
     * Returns MethodInvocation class proxy object.
     * @return MethodInvocation class proxy object.
     */
    public org.netbeans.jmi.javamodel.MethodInvocationClass getMethodInvocation();
    /**
     * Returns ArrayAccess class proxy object.
     * @return ArrayAccess class proxy object.
     */
    public org.netbeans.jmi.javamodel.ArrayAccessClass getArrayAccess();
    /**
     * Returns MultipartId class proxy object.
     * @return MultipartId class proxy object.
     */
    public org.netbeans.jmi.javamodel.MultipartIdClass getMultipartId();
    /**
     * Returns PrimaryExpression class proxy object.
     * @return PrimaryExpression class proxy object.
     */
    public org.netbeans.jmi.javamodel.PrimaryExpressionClass getPrimaryExpression();
    /**
     * Returns PostfixExpression class proxy object.
     * @return PostfixExpression class proxy object.
     */
    public org.netbeans.jmi.javamodel.PostfixExpressionClass getPostfixExpression();
    /**
     * Returns PrefixExpression class proxy object.
     * @return PrefixExpression class proxy object.
     */
    public org.netbeans.jmi.javamodel.PrefixExpressionClass getPrefixExpression();
    /**
     * Returns TypeCast class proxy object.
     * @return TypeCast class proxy object.
     */
    public org.netbeans.jmi.javamodel.TypeCastClass getTypeCast();
    /**
     * Returns UnaryExpression class proxy object.
     * @return UnaryExpression class proxy object.
     */
    public org.netbeans.jmi.javamodel.UnaryExpressionClass getUnaryExpression();
    /**
     * Returns InfixExpression class proxy object.
     * @return InfixExpression class proxy object.
     */
    public org.netbeans.jmi.javamodel.InfixExpressionClass getInfixExpression();
    /**
     * Returns ConditionalExpression class proxy object.
     * @return ConditionalExpression class proxy object.
     */
    public org.netbeans.jmi.javamodel.ConditionalExpressionClass getConditionalExpression();
    /**
     * Returns Assignment class proxy object.
     * @return Assignment class proxy object.
     */
    public org.netbeans.jmi.javamodel.AssignmentClass getAssignment();
    /**
     * Returns Import class proxy object.
     * @return Import class proxy object.
     */
    public org.netbeans.jmi.javamodel.ImportClass getImport();
    /**
     * Returns JavaDoc class proxy object.
     * @return JavaDoc class proxy object.
     */
    public org.netbeans.jmi.javamodel.JavaDocClass getJavaDoc();
    /**
     * Returns TagValue class proxy object.
     * @return TagValue class proxy object.
     */
    public org.netbeans.jmi.javamodel.TagValueClass getTagValue();
    /**
     * Returns TagDefinition class proxy object.
     * @return TagDefinition class proxy object.
     */
    public org.netbeans.jmi.javamodel.TagDefinitionClass getTagDefinition();
    /**
     * Returns Catch class proxy object.
     * @return Catch class proxy object.
     */
    public org.netbeans.jmi.javamodel.CatchClass getCatch();
    /**
     * Returns TryStatement class proxy object.
     * @return TryStatement class proxy object.
     */
    public org.netbeans.jmi.javamodel.TryStatementClass getTryStatement();
    /**
     * Returns AssertStatement class proxy object.
     * @return AssertStatement class proxy object.
     */
    public org.netbeans.jmi.javamodel.AssertStatementClass getAssertStatement();
    /**
     * Returns ThrowStatement class proxy object.
     * @return ThrowStatement class proxy object.
     */
    public org.netbeans.jmi.javamodel.ThrowStatementClass getThrowStatement();
    /**
     * Returns SynchronizedStatement class proxy object.
     * @return SynchronizedStatement class proxy object.
     */
    public org.netbeans.jmi.javamodel.SynchronizedStatementClass getSynchronizedStatement();
    /**
     * Returns ReturnStatement class proxy object.
     * @return ReturnStatement class proxy object.
     */
    public org.netbeans.jmi.javamodel.ReturnStatementClass getReturnStatement();
    /**
     * Returns GotoStatement class proxy object.
     * @return GotoStatement class proxy object.
     */
    public org.netbeans.jmi.javamodel.GotoStatementClass getGotoStatement();
    /**
     * Returns ContinueStatement class proxy object.
     * @return ContinueStatement class proxy object.
     */
    public org.netbeans.jmi.javamodel.ContinueStatementClass getContinueStatement();
    /**
     * Returns BreakStatement class proxy object.
     * @return BreakStatement class proxy object.
     */
    public org.netbeans.jmi.javamodel.BreakStatementClass getBreakStatement();
    /**
     * Returns DoStatement class proxy object.
     * @return DoStatement class proxy object.
     */
    public org.netbeans.jmi.javamodel.DoStatementClass getDoStatement();
    /**
     * Returns Case class proxy object.
     * @return Case class proxy object.
     */
    public org.netbeans.jmi.javamodel.CaseClass getCase();
    /**
     * Returns SwitchStatement class proxy object.
     * @return SwitchStatement class proxy object.
     */
    public org.netbeans.jmi.javamodel.SwitchStatementClass getSwitchStatement();
    /**
     * Returns EmptyStatement class proxy object.
     * @return EmptyStatement class proxy object.
     */
    public org.netbeans.jmi.javamodel.EmptyStatementClass getEmptyStatement();
    /**
     * Returns ForStatement class proxy object.
     * @return ForStatement class proxy object.
     */
    public org.netbeans.jmi.javamodel.ForStatementClass getForStatement();
    /**
     * Returns Condition class proxy object.
     * @return Condition class proxy object.
     */
    public org.netbeans.jmi.javamodel.ConditionClass getCondition();
    /**
     * Returns WhileStatement class proxy object.
     * @return WhileStatement class proxy object.
     */
    public org.netbeans.jmi.javamodel.WhileStatementClass getWhileStatement();
    /**
     * Returns Expression class proxy object.
     * @return Expression class proxy object.
     */
    public org.netbeans.jmi.javamodel.ExpressionClass getExpression();
    /**
     * Returns IfStatement class proxy object.
     * @return IfStatement class proxy object.
     */
    public org.netbeans.jmi.javamodel.IfStatementClass getIfStatement();
    /**
     * Returns LabeledStatement class proxy object.
     * @return LabeledStatement class proxy object.
     */
    public org.netbeans.jmi.javamodel.LabeledStatementClass getLabeledStatement();
    /**
     * Returns Statement class proxy object.
     * @return Statement class proxy object.
     */
    public org.netbeans.jmi.javamodel.StatementClass getStatement();
    /**
     * Returns InitialValue class proxy object.
     * @return InitialValue class proxy object.
     */
    public org.netbeans.jmi.javamodel.InitialValueClass getInitialValue();
    /**
     * Returns LocalVariable class proxy object.
     * @return LocalVariable class proxy object.
     */
    public org.netbeans.jmi.javamodel.LocalVariableClass getLocalVariable();
    /**
     * Returns StructuralElement class proxy object.
     * @return StructuralElement class proxy object.
     */
    public org.netbeans.jmi.javamodel.StructuralElementClass getStructuralElement();
    /**
     * Returns Variable class proxy object.
     * @return Variable class proxy object.
     */
    public org.netbeans.jmi.javamodel.VariableClass getVariable();
    /**
     * Returns StatementBlock class proxy object.
     * @return StatementBlock class proxy object.
     */
    public org.netbeans.jmi.javamodel.StatementBlockClass getStatementBlock();
    /**
     * Returns BehavioralFeature class proxy object.
     * @return BehavioralFeature class proxy object.
     */
    public org.netbeans.jmi.javamodel.BehavioralFeatureClass getBehavioralFeature();
    /**
     * Returns NamedElement class proxy object.
     * @return NamedElement class proxy object.
     */
    public org.netbeans.jmi.javamodel.NamedElementClass getNamedElement();
    /**
     * Returns Codebase class proxy object.
     * @return Codebase class proxy object.
     */
    public org.netbeans.jmi.javamodel.CodebaseClass getCodebase();
    /**
     * Returns Element class proxy object.
     * @return Element class proxy object.
     */
    public org.netbeans.jmi.javamodel.ElementClass getElement();
    /**
     * Returns ClassMember class proxy object.
     * @return ClassMember class proxy object.
     */
    public org.netbeans.jmi.javamodel.ClassMemberClass getClassMember();
    /**
     * Returns TypedElement class proxy object.
     * @return TypedElement class proxy object.
     */
    public org.netbeans.jmi.javamodel.TypedElementClass getTypedElement();
    /**
     * Returns CallableFeature class proxy object.
     * @return CallableFeature class proxy object.
     */
    public org.netbeans.jmi.javamodel.CallableFeatureClass getCallableFeature();
    /**
     * Returns GenericElement class proxy object.
     * @return GenericElement class proxy object.
     */
    public org.netbeans.jmi.javamodel.GenericElementClass getGenericElement();
    /**
     * Returns WildCard class proxy object.
     * @return WildCard class proxy object.
     */
    public org.netbeans.jmi.javamodel.WildCardClass getWildCard();
    /**
     * Returns TypeParameter class proxy object.
     * @return TypeParameter class proxy object.
     */
    public org.netbeans.jmi.javamodel.TypeParameterClass getTypeParameter();
    /**
     * Returns ParameterizedType class proxy object.
     * @return ParameterizedType class proxy object.
     */
    public org.netbeans.jmi.javamodel.ParameterizedTypeClass getParameterizedType();
    /**
     * Returns Type class proxy object.
     * @return Type class proxy object.
     */
    public org.netbeans.jmi.javamodel.TypeClass getType();
    /**
     * Returns Parameter class proxy object.
     * @return Parameter class proxy object.
     */
    public org.netbeans.jmi.javamodel.ParameterClass getParameter();
    /**
     * Returns Array class proxy object.
     * @return Array class proxy object.
     */
    public org.netbeans.jmi.javamodel.ArrayClass getArray();
    /**
     * Returns PrimitiveType class proxy object.
     * @return PrimitiveType class proxy object.
     */
    public org.netbeans.jmi.javamodel.PrimitiveTypeClass getPrimitiveType();
    /**
     * Returns Resource class proxy object.
     * @return Resource class proxy object.
     */
    public org.netbeans.jmi.javamodel.ResourceClass getResource();
    /**
     * Returns JavaPackage class proxy object.
     * @return JavaPackage class proxy object.
     */
    public org.netbeans.jmi.javamodel.JavaPackageClass getJavaPackage();
    /**
     * Returns JavaClass class proxy object.
     * @return JavaClass class proxy object.
     */
    public org.netbeans.jmi.javamodel.JavaClassClass getJavaClass();
    /**
     * Returns Initializer class proxy object.
     * @return Initializer class proxy object.
     */
    public org.netbeans.jmi.javamodel.InitializerClass getInitializer();
    /**
     * Returns Field class proxy object.
     * @return Field class proxy object.
     */
    public org.netbeans.jmi.javamodel.FieldClass getField();
    /**
     * Returns Constructor class proxy object.
     * @return Constructor class proxy object.
     */
    public org.netbeans.jmi.javamodel.ConstructorClass getConstructor();
    /**
     * Returns Method class proxy object.
     * @return Method class proxy object.
     */
    public org.netbeans.jmi.javamodel.MethodClass getMethod();
    /**
     * Returns ContainsSubPackages association proxy object.
     * @return ContainsSubPackages association proxy object.
     */
    public org.netbeans.jmi.javamodel.ContainsSubPackages getContainsSubPackages();
    /**
     * Returns ContainsResources association proxy object.
     * @return ContainsResources association proxy object.
     */
    public org.netbeans.jmi.javamodel.ContainsResources getContainsResources();
    /**
     * Returns Imports association proxy object.
     * @return Imports association proxy object.
     */
    public org.netbeans.jmi.javamodel.Imports getImports();
    /**
     * Returns HasValues association proxy object.
     * @return HasValues association proxy object.
     */
    public org.netbeans.jmi.javamodel.HasValues getHasValues();
    /**
     * Returns IsOfAnnotationType association proxy object.
     * @return IsOfAnnotationType association proxy object.
     */
    public org.netbeans.jmi.javamodel.IsOfAnnotationType getIsOfAnnotationType();
    /**
     * Returns ResolvesTo association proxy object.
     * @return ResolvesTo association proxy object.
     */
    public org.netbeans.jmi.javamodel.ResolvesTo getResolvesTo();
    /**
     * Returns Implements association proxy object.
     * @return Implements association proxy object.
     */
    public org.netbeans.jmi.javamodel.Implements getImplements();
    /**
     * Returns Extends association proxy object.
     * @return Extends association proxy object.
     */
    public org.netbeans.jmi.javamodel.Extends getExtends();
    /**
     * Returns IsValueFor association proxy object.
     * @return IsValueFor association proxy object.
     */
    public org.netbeans.jmi.javamodel.IsValueFor getIsValueFor();
    /**
     * Returns HasBound association proxy object.
     * @return HasBound association proxy object.
     */
    public org.netbeans.jmi.javamodel.HasBound getHasBound();
    /**
     * Returns Throws association proxy object.
     * @return Throws association proxy object.
     */
    public org.netbeans.jmi.javamodel.Throws getThrows();
    /**
     * Returns IsOfType association proxy object.
     * @return IsOfType association proxy object.
     */
    public org.netbeans.jmi.javamodel.IsOfType getIsOfType();
    /**
     * Returns IsParameterizedBy association proxy object.
     * @return IsParameterizedBy association proxy object.
     */
    public org.netbeans.jmi.javamodel.IsParameterizedBy getIsParameterizedBy();
    /**
     * Returns IsDefinedBy association proxy object.
     * @return IsDefinedBy association proxy object.
     */
    public org.netbeans.jmi.javamodel.IsDefinedBy getIsDefinedBy();
    /**
     * Creates an instance of ErrorInfo structure type.
     * @param description 
     * @param lineNumber 
     * @param column 
     * @param severity 
     * @param errorId Unique ID of the kind of error represented by this error 
     * info.
     * @param arguments List of Strings representing error parameters.
     * @return Value of ErrorInfo.
     */
    public org.netbeans.jmi.javamodel.ErrorInfo createErrorInfo(java.lang.String description, int lineNumber, int column, org.netbeans.jmi.javamodel.ErrorType severity, java.lang.String errorId, java.util.List arguments);
}
