/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *  
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *   
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.jmi.javamodel;

/**
 * ErrorInfo structure interface.
 * Class representing a compiler error. The attributes of an error are as 
 * follows:
 * <ul>
 * <li><b>errorId</b> - Unique identifier of the kind of this error.</li>
 * <li><b>arguments</b> - List of String arguments of the error.</li>
 * <li><b>lineNumber</b> - Line number at which the error was found.</li>
 * <li><b>column</b> - Number of column at which the error was found.</li>
 * <li><b>description</b> - Error text (parameterized with the error argum
 * ents).</li>
 * <li><b>severity</b> - Severity of the error (ErrorTypeEnum.ERROR or Err
 * orTypeEnum.WARNING).</li>
 * </ul>
 *  
 * <p><em><strong>Note:</strong> This type should not be subclassed or implemented 
 * by clients. It is generated from a MOF metamodel and automatically implemented 
 * by MDR (see <a href="http://mdr.netbeans.org/">mdr.netbeans.org</a>).</em></p>
 */
public interface ErrorInfo extends javax.jmi.reflect.RefStruct {
    /**
     * Returns value of Description field.
     * @return Value of Description field.
     */
    public java.lang.String getDescription();
    /**
     * Returns value of LineNumber field.
     * @return Value of LineNumber field.
     */
    public int getLineNumber();
    /**
     * Returns value of Column field.
     * @return Value of Column field.
     */
    public int getColumn();
    /**
     * Returns value of Severity field.
     * @return Value of Severity field.
     */
    public org.netbeans.jmi.javamodel.ErrorType getSeverity();
    /**
     * Returns value of ErrorId field.
     * @return Value of ErrorId field.
     */
    public java.lang.String getErrorId();
    /**
     * Returns value of Arguments field.
     * @return Value of Arguments field.
     */
    public java.util.List getArguments();
}
