/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *   
 *  You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *    
 *  The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 *  Microsystems, Inc. All Rights Reserved.
 *  
 */
package org.netbeans.modules.javacore.parsing;

import java.util.Collection;
import java.util.Iterator;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.Token;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.openide.filesystems.FileStateInvalidException;

/**
 * Used for test that token return the same token when
 * calling getFirstToken() and getLastToken() method on the token.
 *
 * @author Pavel Flaska
 */
public class TokenIdentityTest extends NbTestCase {
    
    private static final boolean DEBUG = true;
    
    /** Creates a new instance of TokenIdentityTest */
    public TokenIdentityTest() {
        super("TokenIdentityTest");
    }

    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(TokenIdentityTest.class);
        return suite;
    }
    
    JavaModelPackage pkg;
    
    protected void setUp() throws FileStateInvalidException {
        JavaClass clazz = Utility.findClass("org.netbeans.test.codegen.MethodTest1");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
    }

    public void test() {
        boolean fail = false;
        int files = 0;
        Utility.beginTrans(false);
        try {
            Collection resources = pkg.getResource().refAllOfClass();
            for (Iterator it = resources.iterator(); it.hasNext(); ) {
               MetadataElement element = (MetadataElement) it.next();
               getLog().print("Resource " + ((NamedElement) element).getName() + ' ');
               if (element.getASTree() != null) {
                   ASTree tree = element.getASTree();
                   if (!isCorrect(tree)) {
                       getLog().println("\tError!\n");
                       fail = true;
                   } else {
                       getLog().println("");
                   }
                   files++;
               }
            }
        } finally {
            Utility.endTrans();
        }
        getLog().println("Files: " + files);
        assertFalse(fail);
    }
    
    private boolean isCorrect(ASTree tree) {
        if (tree == null)
            return true;
        ASTree[] sub = tree.getSubTrees();
        if (sub == null) {
            return true;
        }
        for (int i = 0; i < sub.length; i++) {
            if (sub[i] instanceof Token) {
                getLog().print(".");
                Token firstToken = sub[i].getASTContext().getToken(sub[i].getFirstToken());
                Token lastToken = sub[i].getASTContext().getToken(sub[i].getLastToken());
                
                if (sub[i] != firstToken || sub[i] != lastToken) {
                    getLog().println("\n\tToken " + sub[i] + ", hash #" + System.identityHashCode(sub[i]) + "\n" + 
                        "\t\tfirst token: " + firstToken + ", hash #" + System.identityHashCode(firstToken) + "\n" +
                        "\t\tlast  token: " + lastToken + ", hash #" + System.identityHashCode(lastToken) +".");
                    return false;
                }
            } else {
                if (!isCorrect(sub[i])) {
                    return false;
                }
            }
        }
        return true;
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
    
}
