/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.jmi.reflect.RefPackage;
import junit.textui.TestRunner;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.mdr.storagemodel.TransientStorableObject;
import org.netbeans.modules.javacore.api.JavaModel;

/** Test that goes through all the implementations generated from
 * the JMI metamodel and checks whether they are 
 *
 * @author Martin Matula
 */
public class AbstractMethodsTest extends NbTestCase {
    private Set methods;
    
    public static NbTestSuite suite() {
        return new NbTestSuite(AbstractMethodsTest.class);
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        TestRunner.run(suite());
    }

    /** Creates a new instance of AbstractMethodsTest */
    public AbstractMethodsTest(String name) {
        super(name);
    }
    
    public void setUp() {
        methods = new TreeSet();
    }
    
    public void testAllMethodsAreImplemented() {
        checkMetamodel(JavaModel.getDefaultExtent());
        if (!methods.isEmpty()) {
            PrintStream log = getLog();
            for (Iterator it = methods.iterator(); it.hasNext();) {
                log.println(it.next());
            }
            assertTrue(methods.size() + " abstract methods found. See log for details.", false);
        }
    }
    
    private void checkMetamodel(RefPackage pkg) {
        try {
            for (Iterator it = pkg.refAllPackages().iterator(); it.hasNext();) {
                Object obj = it.next();
                checkMetamodel((RefPackage) obj);
                checkObject(obj);
            }
            for (Iterator it = pkg.refAllAssociations().iterator(); it.hasNext();) {
                checkObject(it.next());
            }
            for (Iterator it = pkg.refAllClasses().iterator(); it.hasNext();) {
                Object obj = it.next();
                checkObject(obj);
                checkInstance(obj);
            }
        } catch (StorageException e) {
            throw new RuntimeException(e);
        }
    }
    
    private void checkObject(Object obj) throws StorageException {
        StorableBaseObject storable = ((BaseObjectHandler) obj)._getDelegate();
        checkObject(storable);
    }
    
    private void checkObject(StorableBaseObject storable) {
        Class ifc = BaseObjectHandler.resolveClass(storable);
        checkClass(BaseObjectHandler.getHandlerClass(ifc, storable));
    }
    
    private void checkInstance(Object obj) throws StorageException {
        StorableClass storable = (StorableClass) ((BaseObjectHandler) obj)._getDelegate();
        
        if (!storable.isAbstract()) {
            checkObject(new TransientStorableObject(storable.getMdrStorage(), storable.getImmediatePackageId(), storable.getMetaObjectId(), storable.getMofId()));
        }
    }
    
    private void checkClass(Class cls) {
        try {
            Method[] methods = cls.getMethods();
            for (int i = 0; i < methods.length; i++) {
                if (Modifier.isAbstract(methods[i].getModifiers())) {
                    this.methods.add(cls.getName() + "." + getMethodSignature(methods[i]));
                }
            }
        } catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }
    
    private static String getMethodSignature(Method method) {
        StringBuffer result = new StringBuffer();
        result.append(method.getName() + '(');
        Class[] paramTypes = method.getParameterTypes();
        for (int i = 0; i < paramTypes.length; i++) {
            result.append(paramTypes[i].getName());
            if (i < paramTypes.length - 1) {
                result.append(", ");
            }
        }
        result.append(')');
        return result.toString();
    }
}
