/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.classindex;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;

/**
 * Tests class index. Basic tests for looking for classes in index.
 * Doesn't cover all functionality, only tests method getClassesBySimpleName()
 * and getClassesBySNPrefix() from the class index.
 *
 * @author  Pavel Flaska
 */
public class ClassIndexTest extends NbTestCase {
    private static final String NAME = "ClassIndexTest";
    private static final String PREFIX = "ClassIndex";
    
    JavaModelPackage model;
    ClassIndex index;
    
    /** Creates a new instance of ClassIndexTest */
    public ClassIndexTest() {
        super("ClassIndexTest");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(ClassIndexTest.class);
        return suite;
    }

    protected void setUp() {
        JavaClass clazz = Utility.findClass("org.netbeans.test.classindex.index1." + NAME);
        model = (JavaModelPackage) clazz.refImmediatePackage();
        index = ClassIndex.getIndex(model);
    }

    public void testCaseSensitive() {
        Collection c = index.getClassesBySimpleName(NAME);
        printFound(c);
        if (c.size() != 1) {
            throw new AssertionFailedError("Found #" + c.size() + " classes instead of #1.");
        }
    }
    
    public void testCaseInsensitive() {
        Collection c = index.getClassesBySimpleName(NAME, false);
        printFound(c);
        if (c.size() != 3) {
            throw new AssertionFailedError("Found #" + c.size() + " classes instead of #3.");
        }
    }
    
    public void testPrefixCaseSensitive() {
        Collection c = index.getClassesBySNPrefix(PREFIX);
        printFound(c);
        if (c.size() != 2) {
            throw new AssertionFailedError("Found #" + c.size() + " classes instead of #2.");
        }
    }
    
    public void testPrefixCaseInsensitive() {
        Collection c = index.getClassesBySNPrefix(PREFIX, false);
        printFound(c);
        if (c.size() != 6) {
            throw new AssertionFailedError("Found #" + c.size() + " classes instead of #6.");
        }
    }
    
    private void printFound(Collection c) {
        for (Iterator it = c.iterator(); it.hasNext(); ) {
            getLog().println(it.next());
        }
    }
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }

}
