/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.classindex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.AssertionFailedError;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.javacore.ClassIndex;

/**
 *
 * @author  Pavel Flaska
 */
public class AnnotationIndexTest extends NbTestCase {

    JavaModelPackage model;
    ClassIndex index;
    
    /** Creates a new instance of AnnotationIndexTest */
    public AnnotationIndexTest() {
        super("AnnotationIndexTest");
    }

    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(AnnotationIndexTest.class);
        return suite;
    }

    protected void setUp() {
        JavaClass clazz = Utility.findClass("org.netbeans.test.classindex.annotation.FirstClass");
        model = (JavaModelPackage) clazz.refImmediatePackage();
        index = ClassIndex.getIndex(model);
    }
    
    public void testAnnotationBySNPrefix() {
        Collection c = index.getClassesByFQNPrefix("org.netbeans.test.classindex.annotation.");
        Collection anns = new ArrayList();
        for (Iterator it = c.iterator(); it.hasNext(); ) {
            Object o = it.next();
            if (o instanceof AnnotationType) {
                anns.add(o);
            }
        }
        printFound(anns);
        if (anns.size() != 3) {
            throw new AssertionFailedError("Found #" + c.size() + " classes instead of #3.");
        }
    }
    
    private void printFound(Collection c) {
        for (Iterator it = c.iterator(); it.hasNext(); ) {
            getLog().println(it.next());
        }
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
    
}
