/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.astmatching;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.text.StyledDocument;
import junit.textui.TestRunner;

import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;


/** 
 * @author Jan Becicka
 */
public class MethodsTest extends NbTestCase {
   
    private static final String method1 = "\n" +
    "public static void main (java.lang.String args[]) {\n" +
    "System.out.println(\"foo\");\n" +
    "}\n";
    
    /** Need to be defined because of JUnit */
    public MethodsTest(String name) {
        super(name);
        
    } 
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new MethodsTest("testAddMethod"));
        suite.addTest(new MethodsTest("testChangeMethod"));
        //suite.addTest(new MethodsTest("testRemoveMethod"));
        return suite;
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        TestRunner.run(suite());
    }

    protected void setUp() {
    }
    
    public void testAddMethod() {
        JavaClass clazz = Utility.findClass("org.netbeans.test.astmatching.ClassOne");
        
        StyledDocument doc = Utility.getDocument(clazz);
        Element after = clazz.getField("instanceCounter", false);
        
        MatchUtils.addElement(doc, after, method1);
        
        Utility.beginTrans(true);
        try {
            Method me = MatchUtils.getMethod(clazz, "main", "java.lang.String[]");
            assertNotNull(me);
        } finally {
            Utility.endTrans();
        }
    }
    
    public void testChangeMethod() {
        JavaClass clazz = Utility.findClass("org.netbeans.test.astmatching.ClassOne");
        
        StyledDocument doc = Utility.getDocument(clazz);
        Method m = MatchUtils.getMethod(clazz, "main", "java.lang.String[]");
        
        Parameter p = (Parameter) m.getParameters().iterator().next();
        MatchUtils.addElement(doc, p, ", int a");
        
        Utility.beginTrans(true);
        try {
            Method me = MatchUtils.getMethod(clazz, "main", "java.lang.String[],int");
            assertNotNull(me);
        } finally {
            Utility.endTrans();
        }
    }

    public void testRemoveMethod() {
        
    
    }
    
}
