/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore.astmatching;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;

/**
 *
 * @author  Jan Becicka
 */
public class MatchUtils {
    
    public static void addElement(StyledDocument doc, Element afterElement, String newElement) {
        int offset = JavaMetamodel.getManager().getElementPosition(afterElement).getEnd().getOffset();
        try {
            doc.insertString(offset, newElement, null);
        } catch (BadLocationException bad) {
            throw new RuntimeException(bad);
        }
        
        Utility.saveAll();
        Utility.addModified(afterElement);
    }
    
    public static Method getMethod(JavaClass clazz, String name, String parameters) {
        JavaModelPackage pkg = (JavaModelPackage)clazz.refImmediatePackage();
        StringTokenizer tokenizer = new StringTokenizer(parameters, ",");
        List params = new LinkedList();
        while (tokenizer.hasMoreTokens()) {
            params.add(pkg.getType().resolve(tokenizer.nextToken()));
        }

        Method me = clazz.getMethod(name, params, false);
        return me;
    }
}
