/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.jmi.javamodel.usages;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;


/**
 * @author Martin Matula
 */
public class FindSubTypesTest extends NbTestCase {
    
    public static final String[] SUBTYPES_ABSTRACT_COLLECTION = {
        "org.netbeans.test.subtypes.AbstractList", 
        "org.netbeans.test.subtypes.AbstractSet", 
        "org.netbeans.test.subtypes.HashMap.Values"
    };
    
    public static final String[] SUBTYPES_ABSTRACT_COLLECTION_TRANSITIVE = {
        "org.netbeans.test.subtypes.AbstractList", 
        "org.netbeans.test.subtypes.AbstractSet", 
        "org.netbeans.test.subtypes.HashMap.Values",
        "org.netbeans.test.subtypes.ArrayList",
        "org.netbeans.test.subtypes.HashSet"
    };
    
    public static final String[] SUBTYPES_COLLECTION = {
        "org.netbeans.test.subtypes.Set",
        "org.netbeans.test.subtypes.List",
        "org.netbeans.test.subtypes.AbstractCollection"
    };
    
    public static final String[] SUBTYPES_COLLECTION_TRANSITIVE = {
        "org.netbeans.test.subtypes.AbstractList",
        "org.netbeans.test.subtypes.AbstractCollection",
        "org.netbeans.test.subtypes.List",
        "org.netbeans.test.subtypes.HashMap.Values",
        "org.netbeans.test.subtypes.AbstractSet",
        "org.netbeans.test.subtypes.Set",
        "org.netbeans.test.subtypes.HashSet",
        "org.netbeans.test.subtypes.ArrayList"
    };
    
    public static final String[] SUBCLASSES_ABSTRACT_COLLECTION = {
        "org.netbeans.test.subtypes.AbstractSet",
        "org.netbeans.test.subtypes.HashMap.Values",
        "org.netbeans.test.subtypes.AbstractList"
    };
    
    public static final String[] SUBCLASSES_COLLECTION = {};
    public static final String[] IMPLEMENTORS_ABSTRACT_COLLECTION = {};
    public static final String[] IMPLEMENTORS_COLLECTION = {
        "org.netbeans.test.subtypes.Set",
        "org.netbeans.test.subtypes.List",
        "org.netbeans.test.subtypes.AbstractCollection"
    };
    
    private JavaClass abstractCol;
    private JavaClass col;
    
    /** Need to be defined because of JUnit */
    public FindSubTypesTest(String name) {
        super(name);
    }
    
    public static NbTestSuite suite() {
        return new NbTestSuite(FindSubTypesTest.class);
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        TestRunner.run(suite());
    }
    
    public void setUp() {
        abstractCol = Utility.findClass("org.netbeans.test.subtypes.AbstractCollection");
        col = Utility.findClass("org.netbeans.test.subtypes.Collection");
    }
    
    public void testFindAbstractCollectionSubTypes() {
        compare(abstractCol.findSubTypes(false), SUBTYPES_ABSTRACT_COLLECTION);
    }

    public void testFindAbstractCollectionSubTypesTrans() {
        compare(abstractCol.findSubTypes(true), SUBTYPES_ABSTRACT_COLLECTION_TRANSITIVE);
    }

    public void testFindCollectionSubTypes() {
        compare(col.findSubTypes(false), SUBTYPES_COLLECTION);
    }

    public void testFindCollectionSubTypesTrans() {
        compare(col.findSubTypes(true), SUBTYPES_COLLECTION_TRANSITIVE);
    }
    
    public void testFindAbstractCollectionSubClasses() {
        compare(abstractCol.getSubClasses(), SUBCLASSES_ABSTRACT_COLLECTION);
    }

    public void testFindCollectionSubClasses() {
        compare(col.getSubClasses(), SUBCLASSES_COLLECTION);
    }
    
    public void testFindAbstractCollectionImplementors() {
        compare(abstractCol.getImplementors(), IMPLEMENTORS_ABSTRACT_COLLECTION);
    }

    public void testFindCollectionImplementors() {
        compare(col.getImplementors(), IMPLEMENTORS_COLLECTION);
    }
    
    private void compare(Collection col, String[] classNames) {
        PrintStream log = getLog();
        HashSet names = new HashSet(Arrays.asList(classNames));
        
        boolean passed = true;
        for (Iterator it = col.iterator(); it.hasNext();) {
            String name = ((JavaClass) it.next()).getName();
            if (!names.remove(name)) {
                log.println("Unexpected type found: " + name);
                passed = false;
            }
        }
        
        if (!names.isEmpty()) {
            log.println();
            log.println("Missing types:");
            passed = false;
            for (Iterator it = names.iterator(); it.hasNext();) {
                log.println(it.next());
            }
        }
        if (!passed) {
            fail("Test failed, see log file for details");
        }
    }
}
