/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.jmi.javamodel.usages;

import java.util.Collection;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;

/**
 * @author Jan Becicka (jbecicka@netbeans.org)
 */
public class FindClassUsagesTest extends NbTestCase {
    
    public static final String[] USAGES_COLOR_PICKER = {"NewClassExpression"};
    public static final String[] USAGES_COLOR_PREVIEW = {
        "ClassExpression",
        "ClassExpression",
        "ClassExpression",
        "ClassExpression",
        "Field",
        "NewClassExpression"};
    public static final String[] USAGES_COLOR_PREVIEW_BEANINFO = {};
    public static final String[] USAGES_IMAGE_FRAME = {"LocalVarDeclaration", "NewClassExpression"};
    public static final String[] USAGES_IMAGE_VIEWER = {"NewClassExpression"};
    public static final String[] USAGES_ABOUT = {"NewClassExpression"};
    public static final String[] USAGES_FINDER = {"NewClassExpression"};
    public static final String[] USAGES_TED = {"NewClassExpression"};
    
    /** Need to be defined because of JUnit */
    public FindClassUsagesTest(String name) {
        super(name);
        
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new FindClassUsagesTest("testFindColorPicker"));
        suite.addTest(new FindClassUsagesTest("testFindColorPreview"));
        suite.addTest(new FindClassUsagesTest("testFindColorPreviewBeanInfo"));
        suite.addTest(new FindClassUsagesTest("testFindImageFrame"));
        suite.addTest(new FindClassUsagesTest("testFindImageViewer"));
        suite.addTest(new FindClassUsagesTest("testFindAbout"));
        suite.addTest(new FindClassUsagesTest("testFindFinder"));
        suite.addTest(new FindClassUsagesTest("testFindTed"));
        return suite;
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        TestRunner.run(suite());
    }
    
    public void testFindColorPicker() {
        Collection result = getUsers("examples.colorpicker.ColorPicker");
        compare(result, USAGES_COLOR_PICKER);
    }

    public void testFindColorPreview() {
        Collection result = getUsers("examples.colorpicker.ColorPreview");
        compare(result, USAGES_COLOR_PREVIEW);
    }
    
    public void testFindColorPreviewBeanInfo() {
        Collection result = getUsers("examples.colorpicker.ColorPreviewBeanInfo");
        compare(result, USAGES_COLOR_PREVIEW_BEANINFO);
    }
    
    public void testFindImageFrame() {
        Collection result = getUsers("examples.imageviewer.ImageFrame");
        compare(result, USAGES_IMAGE_FRAME);
    }
    
    public void testFindImageViewer() {
        Collection result = getUsers("examples.imageviewer.ImageViewer");
        compare(result, USAGES_IMAGE_VIEWER);
    }
    
    public void testFindAbout() {
        Collection result = getUsers("examples.texteditor.About");
        compare(result, USAGES_ABOUT);
    }
    
    public void testFindFinder() {
        Collection result = getUsers("examples.texteditor.Finder");
        compare(result, USAGES_FINDER);
    }
    
    public void testFindTed() {
        Collection result = getUsers("examples.texteditor.Ted");
        compare(result, USAGES_TED);
    }
    
    private Collection getUsers(String className) {
        JavaClass myclass = Utility.findClass(className);
        assertNotNull(myclass);
        return myclass.getReferences();
    }
    
    private void compare(Collection col, String[] classNames) {
        FindUtils.compare(col, classNames, getLog());
    }
}
