/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.rollback;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Collections;
import javax.jmi.reflect.ConstraintViolationException;
import junit.textui.TestRunner;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.src.ClassElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;


/**
 * @author  Daniel Prusa
 */
public class RollbackTest extends NbTestCase {
    
    private static final String CLASS_1 = "ClassOne";
    private static final String CLASS_2 = "ClassTwo";
    private static final String CLASS_3 = "ClassThree";
    
    private static final String[] resultFiles = {
        CLASS_1,
        CLASS_2,
        CLASS_3
    };
    
    private String JAVA_EXT = "java";
    private String PASS_EXT = "pass";
    private String PATH_PREFIX = "org/netbeans/test/rollback/";
    private String PACKAGE_PREFIX = "org.netbeans.test.rollback.";

    private TypeClass typeProxy;
    
    /** Need to be defined because of JUnit */
    public RollbackTest(String name) {
        super(name);
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new RollbackTest("testRollback"));
        return suite;
    }
    
    protected void setUp() {
        JavaClass temp = Utility.findClass(PACKAGE_PREFIX + CLASS_1);
        typeProxy = ((JavaModelPackage) temp.refImmediatePackage()).getType();
    }
    
    private void saveFiles() {
        for (int x = 0; x < resultFiles.length; x++) {
            String fileName = PATH_PREFIX + resultFiles[x] + '.' + JAVA_EXT;
            try {
                FileObject fileObj = FileUtil.toFileObject(Utility.getFile(getDataDir(), fileName));
                DataObject dobj = DataObject.find(fileObj);
                SaveCookie sc = (SaveCookie)dobj.getCookie(SaveCookie.class);
                if (sc != null)
                    sc.save();
            } catch (Exception e) {
                fail(e.getMessage());
            }
        }
    }
    
    private void compareFiles() {
        saveFiles();
        try {
            for (int x = 0; x < resultFiles.length; x++) {
                String fileName = PATH_PREFIX + resultFiles[x] + '.' + JAVA_EXT;
                int index = resultFiles[x].lastIndexOf('/') + 1;
                String passName = resultFiles[x].substring(index) + '.' + PASS_EXT;
                assertFile(Utility.getFile(getDataDir(), fileName), getGoldenFile(passName), getWorkDir());
            }
        } catch (FileStateInvalidException e) {
            fail(e.getMessage());
        } catch (IOException e) {
            fail(e.getMessage());
        }
    }
    
    public void testRollback() {
        boolean failed;
        Method method;
        Field field;
        JavaClass jc_one = (JavaClass)typeProxy.resolve(PACKAGE_PREFIX + CLASS_1);
        JavaClass jc_two = (JavaClass)typeProxy.resolve(PACKAGE_PREFIX + CLASS_2);
        JavaClass jc_three = (JavaClass)typeProxy.resolve(PACKAGE_PREFIX + CLASS_3);

        MDRepository repository = JavaMetamodel.getManager().getDefaultRepository();
        
        method = jc_one.getMethod("go", Collections.EMPTY_LIST, false);
        field = jc_two.getField("colour", false);        
        failed = true;
        repository.beginTrans(true);
        try {
            field.setName("color");
            // set body containing a syntax error        
            method.setBodyText("char x;\nSystem.out.println(\"***\");\nx = 'c;System.out.println(x);");
            failed = false;
        } catch (Exception e) {
            fail(e.getMessage());
        } finally {
            try {
                repository.endTrans(failed);
            } catch (ConstraintViolationException e) {
                // expected syntax error
            }
        }
        compareFiles();
        
        failed = true;
        repository.beginTrans(true);
        try {
            FileObject file1 = FileUtil.toFileObject(Utility.getFile(getDataDir(), PATH_PREFIX + resultFiles[2] + '.' + JAVA_EXT));
            ClassElement clsElem = ClassElement.forName(PACKAGE_PREFIX + CLASS_3, file1);
            FieldElement fieldElem = new FieldElement();
            fieldElem.setName(Identifier.create("newField"));
            fieldElem.setType(clsElem.getField(Identifier.create("numero")).getType());
            clsElem.addField(fieldElem);
            
            FileObject file2 = FileUtil.toFileObject(Utility.getFile(getDataDir(), PATH_PREFIX + resultFiles[0] + '.' + JAVA_EXT));
            clsElem = ClassElement.forName(PACKAGE_PREFIX + CLASS_1, file2);
            fieldElem = clsElem.getField(Identifier.create("defaultInstance"));
            fieldElem.setModifiers(Modifier.PUBLIC);
            
            // set incorrect multipart id
            jc_two.getField("name", false).getTypeName().setName("$><...$");
            failed = false;
        } catch (Exception e) {
            fail(e.getMessage());
        } finally {
            try {
                repository.endTrans(failed);
            } catch (ConstraintViolationException e) {
                // expected syntax error
            }
        }
        compareFiles();
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
}
