/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * Main.java
 *
 * Created on 04 December 2003, 18:23
 */

package org.netbeans.jmi.javamodel.regenerator;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.LocalFileSystem;

/**
 *
 * @author Jan Becicka
 */
public class Main extends NbTestCase {
    
    /** Need to be defined because of JUnit */
    public Main(String name) {
        super(name);
        
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new Main("testRegenerateFileSystem"));
        return suite;
    }
    
    /**
     * test can be customized using system properties:
     * org.netbeans.javacore.fsname:        name of filesystem to duplicate
     * e.g. -Dorg.netbeans.javacore.fsname=/tmp/myfs
     *                                    
     * org.netbeans.javacore.useJavadoc:       true = copy javadoc using model elements
     *                                        false = copy javadoc textually
     * e.g. -Dorg.netbeans.javacore.useJavadoc=false
     *
     * org.netbeans.javacore.useBody:          true = copy bodies using model elements
     *                                        false = copy bodies textually
     * e.g. -Dorg.netbeans.javacore.useBody=true
     *
     * org.netbeans.javacore.useInitialValue   true = copy initial values using model elements
     *                                        false = copy initial values textually
     * e.g. -Dorg.netbeans.javacore.useInitialValue=true
     */
    public void testRegenerateFileSystem () {
        String fsName = System.getProperty("org.netbeans.javacore.fsname");
        FileSystem fs = null;
        if (fsName == null) {
            fs = Utility.findFileSystem("sampledir");
        } else {
            try {
                fs = new LocalFileSystem();
                ((LocalFileSystem) fs).setRootDirectory(new File(fsName));
            } catch (PropertyVetoException e) {
                fail(e.toString());
            } catch (IOException e) {
                fail(e.toString());
            }
        }
            
        Regenerator regenerator = new Regenerator();
        regenerator.setSourceFileSystem(fs);
        regenerator.setTargetFileSystem(Utility.findFileSystem("testsrc"));
        regenerator.regenerateAll();
    }
}
