/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * LexDiff.java
 *
 * Created on 09 December 2003, 16:34
 */

package org.netbeans.jmi.javamodel.regenerator;

import java.io.File;
import java.io.FileReader;
import org.netbeans.junit.diff.Diff;
import org.netbeans.lib.java.parser.Factory;

/**
 *
 * @author  jb105785
 */
public class LexDiff implements Diff {
    
    public boolean diff(String str, String str1, String str2) throws java.io.IOException {
        return diff(new File(str), new File(str1), null);
    }
    
    public boolean diff(java.io.File file, java.io.File file1, java.io.File file2) throws java.io.IOException {
        org.netbeans.lib.java.parser.JScanner lex1 = Factory.getDefault().getScanner(new FileReader(file), "pending");
        org.netbeans.lib.java.parser.JScanner lex2 = Factory.getDefault().getScanner(new FileReader(file1), "pending");

        int token1 = lex1.yylex();
        int token2 = lex2.yylex();
        while (token1 != 0 && token2 !=0 ){
            if (token1 != token2) {
                System.out.println("token " + token1 + " (" + lex1.yytext() + ") != " + token2 + " (" + lex2.yytext() + ")" );
                return true;
            }
            if (!lex1.yytext().equals(lex2.yytext())) {
                System.out.println("token " + token1 + " (" + lex1.yytext() + ") != " + token2 + " (" + lex2.yytext() + ")" );
                return true;
            }
            token1 = lex1.yylex();
            token2 = lex2.yylex();
        }
        if (token1 != token2) {
            System.out.println("token " + token1 + " (" + lex1.yytext() + ") != " + token2 + " (" + lex2.yytext() + ")" );
            return true;
        }
        return false;
    }
}
