/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * Cloner.java
 *
 * Created on 05 December 2003, 09:32
 */

package org.netbeans.jmi.javamodel.regenerator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.filesystems.FileSystem;


/**
 *
 * @author Jan Becicka
 */
public class Cloner {
    
    private JavaModelPackage target;
    private FileSystem targetFS;
    private boolean useJavadoc = Boolean.getBoolean("org.netbeans.javacore.useJavadoc");
    private boolean useBody = Boolean.getBoolean("org.netbeans.javacore.useBody");
    private boolean useInitialValue = Boolean.getBoolean("org.netbeans.javacore.useInitialValue");
    
    /** Creates a new instance of Cloner */
    public Cloner(FileSystem targetFS) {
        System.out.println(useBody);
        this.targetFS = targetFS;
        target = JavaMetamodel.getManager().resolveJavaExtent(targetFS.getRoot());
    }
    
    public Resource duplicate(Resource resource) {
        Resource result = target.getResource().createResource(
          resource.getName(),
          resource.getTimestamp(),
          duplicate(resource.getClassifiers()),
          duplicate(resource.getImports()),
          resource.getPackageName(),
          null,
          duplicate(resource.getPackageAnnotations())
          );
        return result;
    }
    
    public List duplicate(List list) {
        if (list == null)
            return null;
        
        if (list.isEmpty())
            return new ArrayList(0);
        
        Iterator it = list.iterator();
        List result = new ArrayList();
        
        while (it.hasNext()) {
            result.add(duplicate(it.next()));
        }
        
        return result;
    }
    
    
    public Parameter duplicate(Parameter param) {
        Parameter result;
        result = target.getParameter().createParameter(
            param.getName(),
            duplicate(param.getAnnotations()),
            param.isFinal(),
            (TypeReference) duplicate(param.getTypeName()),
            param.getDimCount(),
            param.isVarArg()
         );
        //result.setType(param.getType());
        
        return result;
    }
    
    public Initializer duplicate(Initializer init) {
        
        Initializer newinit;
        
        newinit = target.getInitializer().createInitializer(
          init.getName(),
          duplicate(init.getAnnotations()),
          init.getModifiers(),
          useJavadoc?null:init.getJavadocText(),
          useJavadoc?duplicate(init.getJavadoc()):null,
          useBody?duplicate(init.getBody()):null,
          useBody?null:init.getBodyText()
         );
        
        return newinit;
    }
    

    public Import duplicate(Import imp) {
        return target.getImport().createImport(imp.getName(), null, imp.isStatic(), imp.isOnDemand());
    }
    
    public JavaClass duplicate(JavaClass clazz) {
        if (clazz == null)
            return null;

        JavaClass newclazz;
        
        newclazz = target.getJavaClass().createJavaClass(
          clazz.getName(),
          duplicate(clazz.getAnnotations()),
          clazz.getModifiers(),
          useJavadoc?null:clazz.getJavadocText(),
          useJavadoc?duplicate(clazz.getJavadoc()):null,
          duplicate(clazz.getFeatures()),
          duplicate(clazz.getSuperClassName()),
          duplicate(clazz.getInterfaceNames()),
          duplicate(clazz.getTypeParameters())
         );
          
        //newclazz.setInterface(clazz.isInterface());
        //newclazz.setSuperClass(clazz.getSuperClass());
        
        return newclazz;
    }
    
    public Constructor duplicate(Constructor constructor) {

        Constructor newcon;

        newcon = target.getConstructor().createConstructor(
          constructor.getName(),
          duplicate(constructor.getAnnotations()),
          constructor.getModifiers(),
          useJavadoc?null:constructor.getJavadocText(),
          useJavadoc?duplicate(constructor.getJavadoc()):null,
          useBody?duplicate(constructor.getBody()):null,
          useBody?null:constructor.getBodyText(),
          duplicate(constructor.getTypeParameters()),
          duplicate(constructor.getParameters()),
          duplicate(constructor.getExceptionNames())
        );

        //newcon.getExceptions().addAll(constructor.getExceptions());

        return newcon;

        /*
        does not work this way!!!???

        Constructor newcon;

        newcon = target.getConstructor().createConstructor();
        //newcon.setName(constructor.getName());

        //TODO: use setBody instead of setBodyText
        if (constructor.getBodyText() != null)
           newcon.setBodyText(constructor.getBodyText());

        //TODO: use setJavadoc instead of setJavadocText
        if (constructor.getJavadocText() != null)
           newcon.setJavadocText(constructor.getJavadocText());

        newcon.setModifiers(constructor.getModifiers());
        newcon.setType(constructor.getType());
        newcon.getParameters().addAll(constructor.getParameters());
        newcon.getExceptions().addAll(constructor.getExceptions());
        return newcon;
         */
    }
    
    public Method duplicate(Method method) {
        Method newmet;

        newmet = target.getMethod().createMethod(
        method.getName(),
        duplicate(method.getAnnotations()),
        method.getModifiers(),
        useJavadoc?null:method.getJavadocText(),
        useJavadoc?duplicate(method.getJavadoc()):null,
        useBody?duplicate(method.getBody()):null,
        useBody?null:method.getBodyText(),
        duplicate(method.getTypeParameters()),
        duplicate(method.getParameters()),
        duplicate(method.getExceptionNames()),
        (TypeReference) duplicate(method.getTypeName()),
        method.getDimCount()
        );

        //newmet.setType(method.getType());
        //newmet.getExceptions().addAll(method.getExceptions());

        return newmet;


        /*
        does not work this way!!!???

        Method newmet;

        newmet = target.getMethod().createMethod();
        newmet.setName(method.getName());

        //TODO: use setBody instead of setBodyText
        if (newmet.getBodyText() != null)
           newmet.setBodyText(method.getBodyText());

        //TODO: use setJavadoc instead of setJavadocText
        if (newmet.getJavadocText() != null)
           newmet.setJavadocText(method.getJavadocText());

        newmet.setModifiers(method.getModifiers());
        newmet.setType(method.getType());
        newmet.getParameters().addAll(method.getParameters());
        newmet.getExceptions().addAll(method.getExceptions());

        return newmet;
         */
    }
    
    public Field duplicate(Field field) {
        Field newfield;
        
        newfield = target.getField().createField(
          field.getName(), 
          duplicate(field.getAnnotations()),
          field.getModifiers(),
          useJavadoc?null:field.getJavadocText(),
          useJavadoc?duplicate(field.getJavadoc()):null,
          field.isFinal(),
          (TypeReference) duplicate(field.getTypeName()),
          field.getDimCount(),
          useInitialValue?(InitialValue)duplicate(field.getInitialValue()):null,
          useInitialValue?null:field.getInitialValueText()
        );

        newfield.setType(field.getType());
        
        return newfield;

        /*
         * does not work this way
        
        Field newfield;
        
        newfield = target.getField().createField();
        newfield.setName(field.getName());
        
        //TODO: use setJavadoc instead of setJavadocText
        if (field.getJavadocText() != null)
            newfield.setJavadocText(field.getJavadocText());   
        
        newfield.setModifiers(field.getModifiers());
        newfield.setType(field.getType());
        
        //TODO: use setInitialValue instead of setInitialValue
        if (newfield.getInitialValueText() != null)
            newfield.setInitialValueText(field.getInitialValueText());
        
        return newfield;
         */
    }
    
    public JavaDoc duplicate(JavaDoc javadoc) {
        if (javadoc == null)
            return null;
        return target.getJavaDoc().createJavaDoc(javadoc.getText(), duplicate(javadoc.getTags()));
    }
    
    public TagValue duplicate(TagValue elem){
        TagValue val = target.getTagValue().createTagValue(elem.getValue());
        val.setDefinition(duplicate(elem.getDefinition()));
        return val;
    }
    
    public TagDefinition duplicate(TagDefinition elem){
        if (elem == null)
            return null;
        return target.getTagDefinition().createTagDefinition(elem.getName());
    }
    
    //Statements

    public StatementBlock duplicate (StatementBlock statement) {
        return target.getStatementBlock().createStatementBlock(duplicate(statement.getStatements()));
    }
    
    public  LabeledStatement duplicate(LabeledStatement elem) {
        return target.getLabeledStatement().createLabeledStatement(
           elem.getLabel(),
          (Statement) duplicate(elem.getBody())
        );
    }
    
    public  WhileStatement duplicate(WhileStatement elem) {
        return target.getWhileStatement().createWhileStatement(
          (Expression)duplicate(elem.getExpression()),
          (Statement) duplicate(elem.getBody())
        );
    }
    
    public  DoStatement duplicate(DoStatement elem) {
        return target.getDoStatement().createDoStatement(
          (Expression) duplicate(elem.getExpression()),
          (Statement) duplicate(elem.getBody())
        );
    }
    
    public  IfStatement duplicate(IfStatement elem) {
        return target.getIfStatement().createIfStatement(
          (Expression) duplicate(elem.getExpression()),
          (Statement) duplicate(elem.getThenPart()), 
          (Statement) duplicate(elem.getElsePart())
          );
    }
    
    public  AssertStatement duplicate(AssertStatement elem) {
        return target.getAssertStatement().createAssertStatement(
          (Expression) duplicate(elem.getExpression()),
          (Expression) duplicate(elem.getDetail())
        );
    }
    
    public  TryStatement duplicate(TryStatement elem) {
        return target.getTryStatement().createTryStatement(
          duplicate(elem.getBody()),
          duplicate(elem.getCatches()), 
          duplicate(elem.getFinalizer())
          );
    }
    
    public  ConstructorInvocation duplicate(ConstructorInvocation elem) {
        return target.getConstructorInvocation().createConstructorInvocation(
          null,
          duplicate(elem.getParameters()),
          elem.isHasSuper(),
          (PrimaryExpression) duplicate(elem.getParentClass())
          );
    }
    
    public  BreakStatement duplicate(BreakStatement elem) {
        return target.getBreakStatement().createBreakStatement(elem.getLabel());
    }
    
    
    public  ForStatement duplicate(ForStatement elem) {
        return target.getForStatement().createForStatement(
          (Expression) duplicate(elem.getExpression()),
          duplicate(elem.getSteps()),
          (Statement) duplicate(elem.getBody()),
          duplicate(elem.getInit())
          );
    }
    
    
    public LocalVariable duplicate(LocalVariable elem) {
        LocalVariable var = target.getLocalVariable().createLocalVariable(
          elem.getName(),
          //duplicate(elem.getAnnotations()),
          null, 
          elem.isFinal(),
          null,
          elem.getDimCount(),
          useInitialValue?(InitialValue)duplicate(elem.getInitialValue()):null,
          useInitialValue?null:elem.getInitialValueText()
        );
        var.setType(elem.getType());
        return var;
    }

    public  ContinueStatement duplicate(ContinueStatement elem) {
        return target.getContinueStatement().createContinueStatement(elem.getLabel());
    }
    
    
    public  LocalVarDeclaration duplicate(LocalVarDeclaration elem) {
        LocalVarDeclaration result = target.getLocalVarDeclaration().createLocalVarDeclaration(
            elem.isFinal(),
            (TypeReference) duplicate(elem.getTypeName()),
            duplicate(elem.getVariables()));
        //result.setType(elem.getType());
        return result;
    }
    
    
    public  EmptyStatement duplicate(EmptyStatement elem) {
        return target.getEmptyStatement().createEmptyStatement();
    }
    
    
    public  ReturnStatement duplicate(ReturnStatement elem) {
        return target.getReturnStatement().createReturnStatement((Expression) duplicate(elem.getExpression()));
    }
    
    
    public  ForEachStatement duplicate(ForEachStatement elem) {
        return target.getForEachStatement().createForEachStatement(
          (Statement) duplicate(elem.getBody()),
          duplicate(elem.getParameter()),
          (Expression) duplicate(elem.getIterable())
          );
    }
    
    
    public SwitchStatement duplicate(SwitchStatement elem) {
        return target.getSwitchStatement().createSwitchStatement(
          (Expression) duplicate(elem.getExpression()),
          duplicate(elem.getCases())); 
    }
    
    
    public  SynchronizedStatement duplicate(SynchronizedStatement elem) {
        return target.getSynchronizedStatement().createSynchronizedStatement(
          (Expression) duplicate(elem.getLock()),
          duplicate(elem.getBody())
        );
    }
    
    
    public  ThrowStatement duplicate(ThrowStatement elem) {
        return target.getThrowStatement().createThrowStatement((Expression) duplicate(elem.getExpression()));
    }
    
    
    
    //Expressions
    
    public  Annotation duplicate(Annotation elem) {
        Annotation result = target.getAnnotation().createAnnotation(duplicate(elem.getTypeName()), duplicate(elem.getAttributeValues()));
        return result;
    }
    
    
    public  ArrayInitialization duplicate(ArrayInitialization elem) {
        if (elem == null)
            return null;
        ArrayInitialization result = target.getArrayInitialization().createArrayInitialization(duplicate(elem.getElementValues()));
        return result;
    }
    
    
    public  Assignment duplicate(Assignment elem) {
        return target.getAssignment().createAssignment(
          (PrimaryExpression) duplicate(elem.getLeftSide()),
          elem.getOperator(),
          (Expression) duplicate(elem.getRightSide())
          );
    }
    
    
    public  InfixExpression duplicate(InfixExpression elem) {
        return target.getInfixExpression().createInfixExpression(
          (Expression) duplicate(elem.getLeftSide()),
          elem.getOperator(),
          (Expression) duplicate(elem.getRightSide())
        );
    }
    
    
    public  ConditionalExpression duplicate(ConditionalExpression elem) {
        return target.getConditionalExpression().createConditionalExpression(
          (Expression)duplicate(elem.getCondition()),
          (Expression)duplicate(elem.getTruePart()),
          (Expression)duplicate(elem.getFalsePart())
        );
    }
    
    
    public  TypeCast duplicate(TypeCast elem) {
        return target.getTypeCast().createTypeCast((TypeReference) duplicate(elem.getTypeName()), (Expression) duplicate(elem.getExpression()));
    }
    
    
    public  PrefixExpression duplicate(PrefixExpression elem) {
        return target.getPrefixExpression().createPrefixExpression(
          elem.getOperator(),
          (UnaryExpression) duplicate(elem.getExpression())
        );
    }
    
    
    public  Literal duplicate(Literal elem) {
        if (elem instanceof IntLiteral)
            return target.getIntLiteral().createIntLiteral(((IntLiteral) elem).getValue());

        if (elem instanceof StringLiteral)
            return target.getStringLiteral().createStringLiteral(((StringLiteral) elem).getValue());
        
        if (elem instanceof BooleanLiteral)
            return target.getBooleanLiteral().createBooleanLiteral(((BooleanLiteral) elem).isValue());
        
        if (elem instanceof CharLiteral)
            return target.getCharLiteral().createCharLiteral(((CharLiteral) elem).getValue());
        
        if (elem instanceof NullLiteral)
            return target.getNullLiteral().createNullLiteral();
        
        throw new IllegalArgumentException("unknow type to duplicate: " + elem.getClass().getName());
    }
    
    
    public  ThisExpression duplicate(ThisExpression elem) {
        return target.getThisExpression().createThisExpression();
    }
    
    
    public  ComplexExpression duplicate(ComplexExpression elem) {
        return target.getComplexExpression().createComplexExpression((Expression) duplicate(elem.getExpression()));
    }
    
    
    public  ClassExpression duplicate(ClassExpression elem) {
        return target.getClassExpression().createClassExpression();
    }
    
    
    public  PostfixExpression duplicate(PostfixExpression elem) {
        return target.getPostfixExpression().createPostfixExpression(
          elem.getOperator(), 
          (UnaryExpression) duplicate(elem.getExpression())
        ); 
    }
    
    
    public  ArrayAccess duplicate(ArrayAccess elem) {
        return target.getArrayAccess().createArrayAccess(
          (PrimaryExpression) duplicate(elem.getArray()),
          (Expression) duplicate(elem.getIndex())
        );
    }
    
    
    public  NewArrayExpression duplicate(NewArrayExpression elem) {
        return target.getNewArrayExpression().createNewArrayExpression(
          duplicate(elem.getTypeName()),
          duplicate(elem.getDimensions()),
          elem.getDimCount(),
          duplicate(elem.getInitializer())
        );  
    }
    
    
    public  VariableAccess duplicate(VariableAccess elem) {
        return target.getVariableAccess().createVariableAccess(
          elem.getName(),
          (PrimaryExpression) duplicate(elem.getParentClass()),
          elem.isHasSuper()
        );
    }
    
    
    public  MultipartId duplicate(MultipartId elem) {
        if (elem == null) return null;
        return target.getMultipartId().createMultipartId(elem.getName(), duplicate(elem.getParent()), null);
    }
    
    public ArrayReference duplicate(ArrayReference elem) {
        return target.getArrayReference().createArrayReference(elem.getName(), duplicate(elem.getParent()), elem.getDimCount());
    }

    public  MethodInvocation duplicate(MethodInvocation elem) {
        return target.getMethodInvocation().createMethodInvocation(
          elem.getName(),
          duplicate(elem.getParameters()), 
          (PrimaryExpression) duplicate(elem.getParentClass()),
          elem.isHasSuper()
        );
    }
    
    
    public  NewClassExpression duplicate(NewClassExpression elem) {
        return target.getNewClassExpression().createNewClassExpression(
          elem.getName(), 
          duplicate(elem.getParameters()),
          (PrimaryExpression) duplicate(elem.getEnclosingClass()),
          duplicate(elem.getClassName()),
          (ClassDefinition) duplicate(elem.getClassDefinition())
        );
    }
    
    public Object duplicate(Object elem) {
        System.out.println("duplicating " + elem);
        if (elem == null)
            return null;
        
        if (elem instanceof Import)
            return duplicate((Import) elem);
        
        if (elem instanceof JavaClass)
            return duplicate((JavaClass) elem);
        
        if (elem instanceof Method)
            return duplicate((Method) elem);
        
        if (elem instanceof Constructor)
            return duplicate((Constructor) elem);
        
        if (elem instanceof Field)
            return duplicate((Field) elem);
        
        if (elem instanceof Initializer)
            return duplicate((Initializer) elem);
        
        if (elem instanceof Parameter)
            return duplicate((Parameter) elem);
        
        if (elem instanceof Annotation)
            return duplicate((Annotation) elem);
        
        if (elem instanceof ArrayInitialization)
            return duplicate((ArrayInitialization) elem);
        
        if (elem instanceof Assignment)
            return duplicate((Assignment) elem);
        
        if (elem instanceof InfixExpression)
            return duplicate((InfixExpression) elem);
        
        if (elem instanceof ConditionalExpression)
            return duplicate((ConditionalExpression) elem);
        
        if (elem instanceof TypeCast)
            return duplicate((TypeCast) elem);
        
        if (elem instanceof PrefixExpression)
            return duplicate((PrefixExpression) elem);
        
        if (elem instanceof Literal)
            return duplicate((Literal) elem);
        
        if (elem instanceof ThisExpression)
            return duplicate((ThisExpression) elem);
        
        if (elem instanceof ComplexExpression)
            return duplicate((ComplexExpression) elem);
        
        if (elem instanceof ClassExpression)
            return duplicate((ClassExpression) elem);
        
        if (elem instanceof PostfixExpression)
            return duplicate((PostfixExpression) elem);
        
        if (elem instanceof ArrayAccess )
            return duplicate((ArrayAccess) elem);
        
        if (elem instanceof NewArrayExpression)
            return duplicate((NewArrayExpression) elem);
        
        if (elem instanceof VariableAccess)
            return duplicate((VariableAccess) elem);
        
        if (elem instanceof MultipartId)
            return duplicate((MultipartId) elem);
        
        if (elem instanceof MethodInvocation )
            return duplicate((MethodInvocation) elem);
        
        if (elem instanceof NewClassExpression)
            return duplicate((NewClassExpression) elem);
        
        if (elem instanceof LabeledStatement)
            return duplicate((LabeledStatement) elem);
        
        if (elem instanceof WhileStatement)
            return duplicate((WhileStatement) elem);
        
        if (elem instanceof DoStatement)
            return duplicate((DoStatement) elem);
        
        if (elem instanceof IfStatement)
            return duplicate((IfStatement) elem);
        
        if (elem instanceof AssertStatement)
            return duplicate((AssertStatement) elem);
        
        if (elem instanceof TryStatement)
            return duplicate((TryStatement) elem);
        
        if (elem instanceof ConstructorInvocation)
            return duplicate((ConstructorInvocation) elem);
        
        if (elem instanceof BreakStatement)
            return duplicate((BreakStatement) elem);
        
        if (elem instanceof ForStatement)
            return duplicate((ForStatement) elem);
        
        if (elem instanceof ContinueStatement)
            return duplicate((ContinueStatement) elem);
        
        if (elem instanceof LocalVarDeclaration)
            return duplicate((LocalVarDeclaration) elem);
        
        if (elem instanceof EmptyStatement)
            return duplicate((EmptyStatement) elem);
        
        if (elem instanceof ReturnStatement)
            return duplicate((ReturnStatement) elem);
        
        if (elem instanceof ForEachStatement)
            return duplicate((ForEachStatement) elem);
        
        if (elem instanceof SwitchStatement)
            return duplicate((SwitchStatement) elem);
        
        if (elem instanceof SynchronizedStatement)
            return duplicate((SynchronizedStatement) elem);
        
        if (elem instanceof ThrowStatement)
            return duplicate((ThrowStatement) elem);
        
        if (elem instanceof StatementBlock)
            return duplicate((StatementBlock) elem);
        
        if (elem instanceof SynchronizedStatement)
            return duplicate((SynchronizedStatement) elem);
        
        if (elem instanceof SynchronizedStatement)
            return duplicate((SynchronizedStatement) elem);
        
        if (elem instanceof TagValue)
            return duplicate((TagValue) elem);
        
        if (elem instanceof LocalVariable)
            return duplicate((LocalVariable) elem);
        
        if (elem instanceof ArrayReference)
            return duplicate((ArrayReference) elem);
        
        throw new IllegalArgumentException("unknow type to duplicate: " + elem.getClass().getName());
    }
}
