/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.getters;

import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;

/**
 * @author  Pavel Flaska
 */
public class ThrowsClauseTest extends NbTestCase {
    
    JavaClass clazz;
    JavaModelPackage pkg;
    JavaMetamodel model;
    
    private String resultSource = 
        "doTest: Found in resource 'java/lang/Object.java'." +
        "Method 'wait' found." +
        "throws:" +
        "'java.lang.InterruptedException'";
    private String resultClass = 
        "doTest: Found in resource 'java/lang/Object.class'." +
        "Method 'wait' found." +
        "throws:" +
        "'java.lang.InterruptedException'";
    
    /** Creates a new instance of StringMethodsSigTest */
    public ThrowsClauseTest() {
        super("ThrowsClauseTest");
    }

    protected void setUp() {
        clazz = (JavaClass) Utility.findClass("examples.colorpicker.ColorPicker");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
        model = JavaMetamodel.getManager();
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(ThrowsClauseTest.class);
        return suite;
    }

    /**
     * Tries to find String source file in src.zip, resolves it and check if
     * correct equals and hashCode methods are resolved.
     */
    public void testThrowsFromSources() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            model.setClassPath(model.getFileObject(clazz.getResource()), true);
            doTest(resultSource);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
    }
    
    /**
     * Tries to find String class in rt.jar, resolves it and check if
     * correct equals and hashCode methods are resolved.
     */
    public void testThrowsFromClasses() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            model.setClassPath(model.getFileObject(clazz.getResource()));
            doTest(resultClass);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
    
    ////////////////////////////////////////////////////////////////////////////
    // PRIVATE METHODS
    ////////////////////////////////////////////////////////////////////////////
    private void doTest(String result) {
        StringBuffer buf = new StringBuffer(487);
        JavaClass strType = (JavaClass) model.getDefaultExtent().getType().resolve("java.lang.Object");
        Resource res = strType.getResource();
        buf.append("doTest: Found in resource '" + res.getName() + "'.");
        Method method = strType.getMethod("wait", Collections.EMPTY_LIST, false);
        assertNotNull(method);
        buf.append("Method '" + method.getName() + "' found.");
        buf.append("throws:");
        for (Iterator it = method.getExceptions().iterator(); it.hasNext(); ) {
            buf.append("'" + ((JavaClass) it.next()).getName() + "'");
        }
        getLog().println(buf);
        assertEquals("Error.", buf.toString(), result);
    }
    
}
