/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.getters;

import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;

/**
 * Test contains two major parts. It tries to resolve hashCode and equals
 * method in both - rt.jar and src.zip. Then, it checks signature of this
 * both methods.
 *
 * @author  Pavel Flaska
 */
public class StringMethodsSigTest extends NbTestCase {
    
    JavaClass clazz;
    JavaModelPackage pkg;
    JavaMetamodel model;
    
    /** Creates a new instance of StringMethodsSigTest */
    public StringMethodsSigTest() {
        super("StringMethodsSigTest");
    }

    protected void setUp() {
        clazz = (JavaClass) Utility.findClass("examples.colorpicker.ColorPicker");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
        model = JavaMetamodel.getManager();
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(StringMethodsSigTest.class);
        return suite;
    }

    /**
     * Tries to find String source file in src.zip, resolves it and check if
     * correct equals and hashCode methods are resolved.
     */
    public void testMethodsFromSources() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            model.setClassPath(model.getFileObject(clazz.getResource()), true);
            doTest();
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
    }
    
    public void testMethodsFromSources2() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            model.setClassPath(model.getFileObject(clazz.getResource()), true);
            doTest2();
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
    }
    
    /**
     * Tries to find String class in rt.jar, resolves it and check if
     * correct equals and hashCode methods are resolved.
     */
    public void testMethodsFromClasses() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            model.setClassPath(model.getFileObject(clazz.getResource()));
            doTest();
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
    }
    
    public void testMethodsFromClasses2() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            model.setClassPath(model.getFileObject(clazz.getResource()));
            doTest2();
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
    
    ////////////////////////////////////////////////////////////////////////////
    // PRIVATE METHODS
    ////////////////////////////////////////////////////////////////////////////
    private void doTest() {
        PrintStream log = getLog();
        JavaClass strType = (JavaClass) model.getDefaultExtent().getType().resolve("java.lang.String");
        Resource res = strType.getResource();
        log.println("doTest: Found in resource '" + res.getName() + "'.");
        Method method = strType.getMethod("hashCode", Collections.EMPTY_LIST, false);
        assertNotNull(method);
        log.println("\tMethod '" + method.getName() + "' found.");
        log.println("\t\tisFinal: '" + Modifier.isFinal(method.getModifiers()) + "'.");
        assertEquals(true, Modifier.isFinal(method.getModifiers()));
        Type objectType = model.getDefaultExtent().getType().resolve("java.lang.Object");
        method = strType.getMethod("equals", Collections.singletonList(objectType), false);
        log.println("\tMethod '" + method.getName() + "' found.");
        assertNotNull(method);
    }
    
    private void doTest2() {
        PrintStream log = getLog();
        JavaClass strType = (JavaClass) model.getDefaultExtent().getType().resolve("java.lang.String");
        ParameterizedType parType = model.getDefaultExtent().getParameterizedType().resolveParameterizedType(strType, null, null);
        Resource res = strType.getResource();
        log.println("doTest2: Found in resource '" + res.getName() + "'.");
        Method method = findMethod(parType, "hashCode");
        assertNotNull(method);
        log.println("\tMethod '" + method.getName() + "' found.");
        log.println("\t\tisFinal: '" + Modifier.isFinal(method.getModifiers()) + "'.");
        assertEquals(true, Modifier.isFinal(method.getModifiers()));
        Type objectType = model.getDefaultExtent().getType().resolve("java.lang.Object");
        method = findMethod(parType, "equals");
        log.println("\tMethod '" + method.getName() + "' found.");
        assertNotNull(method);
    }
    
    private Method findMethod(ParameterizedType type, String name) {
        List features = type.getFeatures();
        for (Iterator it = features.iterator(); it.hasNext(); ) {
            Feature feature = (Feature) it.next();
            if (name.equals(feature.getName()) && (feature instanceof Method)) {
                return (Method) feature;
            }
        }
        return null;
    }
}
