/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.getters;

import java.util.Iterator;
import java.util.List;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.junit.NbTestCase;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaDoc;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.TagValue;
import org.netbeans.junit.NbTestSuite;

/*
 *
 * @author Pavel Flaska
 */
public class JavaDocTextTest extends NbTestCase {
    
    JavaClass clazz;
    JavaModelPackage pkg;
   
    public JavaDocTextTest() {
        super("JavaDocTextTest");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(JavaDocTextTest.class);
        return suite;
    }
    
    protected void setUp() {
        clazz = (JavaClass) Utility.findClass("org.netbeans.test.getters.JavaDocText");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
    }

    public void testGet1() {
        testText(2);
    }
    
    public void testGet2() {
        testText(3);
    }
    
    public void testGet3() {
        testText(4);
    }
    
    public void testGet4() {
        testText(5);
    }
    
    public void testGetDoc1() {
        String[][] result = {
            { "@param", "c   cecko" },
            { "@param", "ax  aikso" },
            { "@param", "b   becko" },
            { "@author", "Lee Boynton" },
            { "@author", "Arthur van Hoff" },
            { "@version", "unknown" },
            { "@see", "java.lang.Object#toString()" },
            { "@see", "java.nio.charset.Charset" },
            { "@since", "1895" }
        };
        Utility.beginTrans(false);
        try {
            Feature f = (Feature) clazz.getContents().get(6);
            JavaDoc javadoc = f.getJavadoc();
            String text = javadoc.getText();
            assertEquals(" Nothing interesting.\n", text);
            List/*TagValue*/ tags = javadoc.getTags();
            getLog().println(text);
            int i = 0;
            for (Iterator it = tags.iterator(); it.hasNext(); i++) {
                TagValue tag = (TagValue) it.next();
                getLog().print(tag.getDefinition().getName() + "; ");
                getLog().println(tag.getValue());
                assertEquals(result[i][0], tag.getDefinition().getName());
                assertEquals(result[i][1], tag.getValue());
            }
        }
        finally {
            Utility.endTrans();
        }
    }
    
    private void testText(int index) {
        Utility.beginTrans(false);
        try {
            Feature f = (Feature) clazz.getContents().get(index);
            String javadocText = f.getJavadocText();
            getLog().println("Obtained text '" + javadocText + "'");
            getLog().println("Expected text '" + resultsText[index] + "'");
            assertEquals(resultsText[index], javadocText);
        }
        finally {
            Utility.endTrans();
        }
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        TestRunner.run(suite());
    }
    
    String[] resultsText = {
        "",
        "",
        " Creates a new instance of JavaDocText ",
        " Constructor with one parameter.\n\n @param charles karluv parameter\n",
        " Methoda.\n \n @param a letter\n @param text does not matter\n @return no comment\n",
        " In this javadoc text, there are more new lines,\n missing asterisks at the beginning, html tags\n" +
            "<pre>\n    Preformatted.\n</pre>\n and many other things.\n Not only that, but also more new lines" +
            " at the\n end of the comment are tested.\n\n\n"
    };

}
