/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.getters;

import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.javacore.ClassIndex;

/**
 * Test for javaClass creation with creaJavaClass() method without parameters.
 * It is connected also with classIndex, where the class should be added.
 *
 * todo (#pf): We still need to solve situation, when class is not added to
 * resource. Such a class is never removed from the index. There is no guarantee
 * that jmi user adds it.
 *
 * @author  Pavel Flaska
 */
public class JavaClassCreationTest extends NbTestCase {
    
    JavaClass clazz;
    JavaModelPackage pkg;
    
    /** Creates a new instance of JavaClassCreationTest */
    public JavaClassCreationTest() {
        super("JavaClassCreationTest");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(JavaClassCreationTest.class);
        return suite;
    }
    
    protected void setUp() {
        clazz = (JavaClass) Utility.findClass("examples.colorpicker.ColorPicker");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
    }
    
    /**
     * Create javaClass model element. Use proxy method createJavaClass()
     * without parameters.
     */
    public void testJavaClassCreation() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            clazz = pkg.getJavaClass().createJavaClass();
            clazz.setName("SetTheNameOnClassWhichHadNotNameYet");
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
    }
    
    /**
     * Look for class created in previous test. If such a class is not in index,
     * something is wrong.
     */
    public void testLookForCreatedClassInIndex() {
        ClassIndex index = ClassIndex.getIndex(pkg);
        clazz = index.getClassByFqn("SetTheNameOnClassWhichHadNotNameYet");
        assertNotNull(clazz);
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
    
}
