/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.getters;

import java.lang.reflect.Modifier;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.javacore.parser.MDRParser;

/**
 *
 * @author  Pavel Flaska
 */
public class EnumModifiersTest extends NbTestCase {
    
    JavaClass clazz;
    JavaModelPackage pkg;
    
    /** Creates a new instance of EnumModifiersTest */
    public EnumModifiersTest() {
        super("EnumModifiersTest");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(EnumModifiersTest.class);
        return suite;
    }
    
    protected void setUp() {
        clazz = (JavaClass) Utility.findClass("org.netbeans.test.getters.EnumGetters");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
    }
    
    public void testGetModifiers() {
        Utility.beginTrans(false);
        try {
            int modifiers = clazz.getModifiers();
            getLog().println("modifiers: " + modifiers);
            getLog().println("\tmodifiers.toString(): " + Modifier.toString(modifiers));
            int resultMods = (MDRParser.M_ENUM | Modifier.PUBLIC);
            assertEquals(modifiers & resultMods, resultMods);
        }
        finally {
            Utility.endTrans();
        }
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }

}
