/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.getters;

import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.jmi.javamodel.*;

/**
 *
 * @author  Pavel Flaska
 */
public class AnnTypeRetentionTest extends NbTestCase {
    
    AnnotationType clazz;
    JavaModelPackage pkg;
    Attribute[] attribute;
    
    /** Creates a new instance of AnnTypeRetentionTest */
    public AnnTypeRetentionTest() {
        super("AnnTypeRetentionTest");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(AnnTypeRetentionTest.class);
        return suite;
    }
    
    protected void setUp() {
        clazz = (AnnotationType) Utility.findClass("java.lang.annotation.Retention");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
    }

    public void testGetContents() {
        Attribute attr = (Attribute) clazz.getContents().iterator().next();
        assertEquals("Retention annotation was not correctly created in model", "value", attr.getName());
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
    
}


    