/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.getters;

import java.io.PrintStream;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.jmi.javamodel.*;

/**
 * Test getters of Attribute model element.
 *
 * @author  Pavel Flaska
 */
public class AnnTypeAttrTest extends NbTestCase {
    
    private static String[] correctIdentifiers = {
        "id",
        "synopsis",
        "engineer",
        "date"
    };
    
    private static String[] correctDefValuesText = {
        null,
        "\"MaM likes M&M's.\"",
        null,
        null
    };
    
    private static String[] correctTypeNames = {
        "int",
        "String",
        "String",
        "String"
    };
    
    private static String[] correctTypes = {
        "int",
        "java.lang.String",
        "java.lang.String",
        "java.lang.String"
    };
    
    AnnotationType clazz;
    JavaModelPackage pkg;
    Attribute[] attribute;
    
    /** Creates a new instance of AnnTypeAttrTest */
    public AnnTypeAttrTest() {
        super("AnnTypeAttrTest");
        attribute = new Attribute[4];
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(AnnTypeAttrTest.class);
        return suite;
    }
    
    protected void setUp() {
        clazz = (AnnotationType) Utility.findClass("org.netbeans.test.getters.AnnotationType");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
        for (int i = 0; i < 4; i++) {
            attribute[i] = (Attribute) clazz.getContents().get(i);
        }
    }
    
    public void testAttributeIdentifier() {
        PrintStream log = getLog();
        log.println("Found identifiers:");
        for (int i = 0; i < 4; i++) {
            String name = attribute[i].getName();
            log.println("\t" + name);
            assertEquals("Identifier differs!", name, correctIdentifiers[i]);
        }
    }
    
    public void testAttributeDefaultValue() {
        /*
        PrintStream log = getLog();
        log.println("Found default value texts:");
        for (int i = 0; i < 4; i++) {
            String defaultValue = ((InitialValueImpl) attribute[i].getDefaultValue()).getSourceText();
            log.print("\t" + defaultValue);
            assertEquals("Default values differ!", defaultValue, correctDefValuesText[i]);
        }
         */
    }
    
    public void testAttributeDefaultValueText() {
        PrintStream log = getLog();
        log.println("Found default value texts:");
        for (int i = 0; i < 4; i++) {
            String defaultValueText = attribute[i].getDefaultValueText();
            log.println("\t" + defaultValueText);
            assertEquals("Default Values differ!", defaultValueText, correctDefValuesText[i]);
        }
    }
    
    public void testAttributeType() {
        PrintStream log = getLog();
        log.println("Found types:");
        for (int i = 0; i < 4; i++) {
            String type = attribute[i].getType().getName();
            log.println("\t" + type + "; " + correctTypes[i]);
            assertEquals("Attribute types differ!", type, correctTypes[i]);
        }
    }
    
    public void testAttributeTypeName() {
        PrintStream log = getLog();
        log.println("Found type names:");
        for (int i = 0; i < 4; i++) {
            String typeName = attribute[i].getTypeName().getName();
            log.println("\t" + typeName + "; " + correctTypeNames[i]);
            assertEquals("Attribute type names differ!", typeName, correctTypeNames[i]);
        }
    }
    
    public void testAttributeGetType() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Attribute attr = pkg.getAttribute().createAttribute("newA", null, 0, null, null, null, null, null);
            Type type = attr.getType();
            getLog().println("Type is '" + type + "'.");
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
    
}
